<?php
// 1. Hook the registration function to the 'rest_api_init' action
add_action('rest_api_init', 'remove_product_from_wishlist_api_register_routes');

function remove_product_from_wishlist_api_register_routes()
{
    $namespace = 'api/v1'; // Namespace for your custom route prefixed with /wp-json/
    $route = '/remove-product-from-wishlist';          // The specific route segment

    register_rest_route($namespace, $route, array(
        'methods' => 'POST', // HTTP method (GET, POST, etc.)
        'callback' => 'remove_product_from_wishlist_api_callback', // Function to execute
        'permission_callback' => '__return_true', // Authentication check (true for public)
    ));
}

// 2. The Callback Function
function remove_product_from_wishlist_api_callback($request){
    global $wpdb;

    $params = $request->get_params();

    $user = get_user_by('login', $params['username']);

    $sql = "DELETE FROM wp_extra_wishlist_products 
            WHERE productId = " . $params['productId'] . " 
            AND userId = " . $user->ID . " 
            ;";
    
    try {
        $result = $wpdb->query($sql);

        if($result === false) {
            $error_message = $wpdb->last_error;
            $data = [
            "remove_product" => false,
                "error" => $error_message
            ];
        } else {
            //echo "Product removed successfully!";
            $data = [
            "remove_product" => true,
                "message" => "Product removed successfully!"
            ];
        }
        
    } catch (Exception $ex) {
        
    }

    return new WP_REST_Response($data, 200);
}

