<?php
/**
 * ECheckConfigCommonInternalOnlyProcessors
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * ECheckConfigCommonInternalOnlyProcessors Class Doc Comment
 *
 * @category    Class
 * @description Name of the payment processor. Example - \&quot;wellsfargoach\&quot;
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ECheckConfigCommonInternalOnlyProcessors implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ECheckConfig_common_internalOnly_processors';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'enableCCS' => 'bool',
        'terminalId' => 'string',
        'enable15anTransactionReferenceNumber' => 'bool',
        'portalSupportedPaytypes' => 'string',
        'settlementMethod' => 'string',
        'verificationLevel' => 'string',
        'setCompletedState' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'enableCCS' => null,
        'terminalId' => null,
        'enable15anTransactionReferenceNumber' => null,
        'portalSupportedPaytypes' => null,
        'settlementMethod' => null,
        'verificationLevel' => null,
        'setCompletedState' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'enableCCS' => 'enableCCS',
        'terminalId' => 'terminalId',
        'enable15anTransactionReferenceNumber' => 'enable15anTransactionReferenceNumber',
        'portalSupportedPaytypes' => 'portalSupportedPaytypes',
        'settlementMethod' => 'settlementMethod',
        'verificationLevel' => 'verificationLevel',
        'setCompletedState' => 'setCompletedState'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'enableCCS' => 'setEnableCCS',
        'terminalId' => 'setTerminalId',
        'enable15anTransactionReferenceNumber' => 'setEnable15anTransactionReferenceNumber',
        'portalSupportedPaytypes' => 'setPortalSupportedPaytypes',
        'settlementMethod' => 'setSettlementMethod',
        'verificationLevel' => 'setVerificationLevel',
        'setCompletedState' => 'setSetCompletedState'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'enableCCS' => 'getEnableCCS',
        'terminalId' => 'getTerminalId',
        'enable15anTransactionReferenceNumber' => 'getEnable15anTransactionReferenceNumber',
        'portalSupportedPaytypes' => 'getPortalSupportedPaytypes',
        'settlementMethod' => 'getSettlementMethod',
        'verificationLevel' => 'getVerificationLevel',
        'setCompletedState' => 'getSetCompletedState'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['enableCCS'] = isset($data['enableCCS']) ? $data['enableCCS'] : null;
        $this->container['terminalId'] = isset($data['terminalId']) ? $data['terminalId'] : null;
        $this->container['enable15anTransactionReferenceNumber'] = isset($data['enable15anTransactionReferenceNumber']) ? $data['enable15anTransactionReferenceNumber'] : true;
        $this->container['portalSupportedPaytypes'] = isset($data['portalSupportedPaytypes']) ? $data['portalSupportedPaytypes'] : 'CHECK';
        $this->container['settlementMethod'] = isset($data['settlementMethod']) ? $data['settlementMethod'] : 'BEST_GUESS';
        $this->container['verificationLevel'] = isset($data['verificationLevel']) ? $data['verificationLevel'] : 'VALIDATION';
        $this->container['setCompletedState'] = isset($data['setCompletedState']) ? $data['setCompletedState'] : false;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets enableCCS
     * @return bool
     */
    public function getEnableCCS()
    {
        return $this->container['enableCCS'];
    }

    /**
     * Sets enableCCS
     * @param bool $enableCCS *NEW* Flag to indicate whether the processor is migrated to the Common Connectivity Services Platform. Applicable for VPC and amexdirect processors.
     * @return $this
     */
    public function setEnableCCS($enableCCS)
    {
        $this->container['enableCCS'] = $enableCCS;

        return $this;
    }

    /**
     * Gets terminalId
     * @return string
     */
    public function getTerminalId()
    {
        return $this->container['terminalId'];
    }

    /**
     * Sets terminalId
     * @param string $terminalId *NEW* The 'Terminal Id' aka TID, is an identifier used for with your payments processor. Depending on the processor and payment acceptance type this may also be the default Terminal ID used for Card Present and Virtual Terminal transactions. Applicable for VPC processors.
     * @return $this
     */
    public function setTerminalId($terminalId)
    {
        $this->container['terminalId'] = $terminalId;

        return $this;
    }

    /**
     * Gets enable15anTransactionReferenceNumber
     * @return bool
     */
    public function getEnable15anTransactionReferenceNumber()
    {
        return $this->container['enable15anTransactionReferenceNumber'];
    }

    /**
     * Sets enable15anTransactionReferenceNumber
     * @param bool $enable15anTransactionReferenceNumber *NEW* This ensures the transaction reference # contains an identifier that can be viewed in CYBS
     * @return $this
     */
    public function setEnable15anTransactionReferenceNumber($enable15anTransactionReferenceNumber)
    {
        $this->container['enable15anTransactionReferenceNumber'] = $enable15anTransactionReferenceNumber;

        return $this;
    }

    /**
     * Gets portalSupportedPaytypes
     * @return string
     */
    public function getPortalSupportedPaytypes()
    {
        return $this->container['portalSupportedPaytypes'];
    }

    /**
     * Sets portalSupportedPaytypes
     * @param string $portalSupportedPaytypes *NEW* This is used by the EBC2 application
     * @return $this
     */
    public function setPortalSupportedPaytypes($portalSupportedPaytypes)
    {
        $this->container['portalSupportedPaytypes'] = $portalSupportedPaytypes;

        return $this;
    }

    /**
     * Gets settlementMethod
     * @return string
     */
    public function getSettlementMethod()
    {
        return $this->container['settlementMethod'];
    }

    /**
     * Sets settlementMethod
     * @param string $settlementMethod *NEW*  Possible values: - BEST_GUESS
     * @return $this
     */
    public function setSettlementMethod($settlementMethod)
    {
        $this->container['settlementMethod'] = $settlementMethod;

        return $this;
    }

    /**
     * Gets verificationLevel
     * @return string
     */
    public function getVerificationLevel()
    {
        return $this->container['verificationLevel'];
    }

    /**
     * Sets verificationLevel
     * @param string $verificationLevel *NEW*  Possible values: - VALIDATION
     * @return $this
     */
    public function setVerificationLevel($verificationLevel)
    {
        $this->container['verificationLevel'] = $verificationLevel;

        return $this;
    }

    /**
     * Gets setCompletedState
     * @return bool
     */
    public function getSetCompletedState()
    {
        return $this->container['setCompletedState'];
    }

    /**
     * Sets setCompletedState
     * @param bool $setCompletedState *Moved* When set to Yes we will automatically update transactions to a completed status X-number of days after the transaction comes through; if no failure notification is received. When set to No means we will not update transaction status in this manner. For BAMS/Bank of America merchants, they should be set to No unless we are explicitly asked to set a merchant to YES.
     * @return $this
     */
    public function setSetCompletedState($setCompletedState)
    {
        $this->container['setCompletedState'] = $setCompletedState;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


