<?php
/**
 * ECheckConfigUnderwriting
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * ECheckConfigUnderwriting Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ECheckConfigUnderwriting implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ECheckConfig_underwriting';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'standardEntryClassCodes' => 'string',
        'enableHold' => 'bool',
        'monthlyTotalTransactionAmountLimit' => 'float',
        'holdingDays' => 'float',
        'enableCredits' => 'bool',
        'transactionAmountLimit' => 'float',
        'riskReserveMethod' => 'string',
        'riskReserveRate' => 'float',
        'riskReserveTargetAmount' => 'float',
        'solutionOrganizationId' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'standardEntryClassCodes' => null,
        'enableHold' => null,
        'monthlyTotalTransactionAmountLimit' => 'currency',
        'holdingDays' => 'integer',
        'enableCredits' => null,
        'transactionAmountLimit' => 'currency',
        'riskReserveMethod' => null,
        'riskReserveRate' => 'decimal',
        'riskReserveTargetAmount' => 'currency',
        'solutionOrganizationId' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'standardEntryClassCodes' => 'standardEntryClassCodes',
        'enableHold' => 'enableHold',
        'monthlyTotalTransactionAmountLimit' => 'monthlyTotalTransactionAmountLimit',
        'holdingDays' => 'holdingDays',
        'enableCredits' => 'enableCredits',
        'transactionAmountLimit' => 'transactionAmountLimit',
        'riskReserveMethod' => 'riskReserveMethod',
        'riskReserveRate' => 'riskReserveRate',
        'riskReserveTargetAmount' => 'riskReserveTargetAmount',
        'solutionOrganizationId' => 'solutionOrganizationId'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'standardEntryClassCodes' => 'setStandardEntryClassCodes',
        'enableHold' => 'setEnableHold',
        'monthlyTotalTransactionAmountLimit' => 'setMonthlyTotalTransactionAmountLimit',
        'holdingDays' => 'setHoldingDays',
        'enableCredits' => 'setEnableCredits',
        'transactionAmountLimit' => 'setTransactionAmountLimit',
        'riskReserveMethod' => 'setRiskReserveMethod',
        'riskReserveRate' => 'setRiskReserveRate',
        'riskReserveTargetAmount' => 'setRiskReserveTargetAmount',
        'solutionOrganizationId' => 'setSolutionOrganizationId'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'standardEntryClassCodes' => 'getStandardEntryClassCodes',
        'enableHold' => 'getEnableHold',
        'monthlyTotalTransactionAmountLimit' => 'getMonthlyTotalTransactionAmountLimit',
        'holdingDays' => 'getHoldingDays',
        'enableCredits' => 'getEnableCredits',
        'transactionAmountLimit' => 'getTransactionAmountLimit',
        'riskReserveMethod' => 'getRiskReserveMethod',
        'riskReserveRate' => 'getRiskReserveRate',
        'riskReserveTargetAmount' => 'getRiskReserveTargetAmount',
        'solutionOrganizationId' => 'getSolutionOrganizationId'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['standardEntryClassCodes'] = isset($data['standardEntryClassCodes']) ? $data['standardEntryClassCodes'] : 'CCD,PPD,TEL,WEB';
        $this->container['enableHold'] = isset($data['enableHold']) ? $data['enableHold'] : true;
        $this->container['monthlyTotalTransactionAmountLimit'] = isset($data['monthlyTotalTransactionAmountLimit']) ? $data['monthlyTotalTransactionAmountLimit'] : null;
        $this->container['holdingDays'] = isset($data['holdingDays']) ? $data['holdingDays'] : null;
        $this->container['enableCredits'] = isset($data['enableCredits']) ? $data['enableCredits'] : null;
        $this->container['transactionAmountLimit'] = isset($data['transactionAmountLimit']) ? $data['transactionAmountLimit'] : null;
        $this->container['riskReserveMethod'] = isset($data['riskReserveMethod']) ? $data['riskReserveMethod'] : null;
        $this->container['riskReserveRate'] = isset($data['riskReserveRate']) ? $data['riskReserveRate'] : null;
        $this->container['riskReserveTargetAmount'] = isset($data['riskReserveTargetAmount']) ? $data['riskReserveTargetAmount'] : null;
        $this->container['solutionOrganizationId'] = isset($data['solutionOrganizationId']) ? $data['solutionOrganizationId'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        if ($this->container['standardEntryClassCodes'] === null) {
            $invalid_properties[] = "'standardEntryClassCodes' can't be null";
        }
        if ($this->container['enableHold'] === null) {
            $invalid_properties[] = "'enableHold' can't be null";
        }
        if ($this->container['monthlyTotalTransactionAmountLimit'] === null) {
            $invalid_properties[] = "'monthlyTotalTransactionAmountLimit' can't be null";
        }
        if ($this->container['holdingDays'] === null) {
            $invalid_properties[] = "'holdingDays' can't be null";
        }
        if ($this->container['transactionAmountLimit'] === null) {
            $invalid_properties[] = "'transactionAmountLimit' can't be null";
        }
        if ($this->container['riskReserveMethod'] === null) {
            $invalid_properties[] = "'riskReserveMethod' can't be null";
        }
        if ($this->container['riskReserveRate'] === null) {
            $invalid_properties[] = "'riskReserveRate' can't be null";
        }
        if ($this->container['riskReserveTargetAmount'] === null) {
            $invalid_properties[] = "'riskReserveTargetAmount' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        if ($this->container['standardEntryClassCodes'] === null) {
            return false;
        }
        if ($this->container['enableHold'] === null) {
            return false;
        }
        if ($this->container['monthlyTotalTransactionAmountLimit'] === null) {
            return false;
        }
        if ($this->container['holdingDays'] === null) {
            return false;
        }
        if ($this->container['transactionAmountLimit'] === null) {
            return false;
        }
        if ($this->container['riskReserveMethod'] === null) {
            return false;
        }
        if ($this->container['riskReserveRate'] === null) {
            return false;
        }
        if ($this->container['riskReserveTargetAmount'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets standardEntryClassCodes
     * @return string
     */
    public function getStandardEntryClassCodes()
    {
        return $this->container['standardEntryClassCodes'];
    }

    /**
     * Sets standardEntryClassCodes
     * @param string $standardEntryClassCodes Mandatory  Free-text (csv)  Possible values (combination):  CCD — Cash Concentration or Disbursement, or CCD, is a charge or refund against a business checking account. One-time or recurring CCD transactions are fund transfers to or from a corporate entity. A standing authorization is required for recurring transactions. PPD — Prearranged Payment and Deposit Entry, or PPD, is a charge or refund against a customer's checking or savings account. PPD entries can only be originated when payment and deposit terms between the merchant and the customer are prearranged. A written authorization from the customer is required for one-time transactions and a written standing authorization is required for recurring transactions. TEL — Telephone-Initiated Entry, or TEL, is a one-time charge against a customer's checking or savings account. TEL transactions can only be originated when a business relationship between the merchant and the customer already exists; or if a relationship does not exist, then only when the customer initiates the telephone call to the merchant. Payment authorization is obtained from the customer by telephone. WEB — Internet-Initiated Entry or WEB is a charge against a customer's checking or savings account. One-time or recurring WEB transactions are originated through the Internet. Payment authorization is also obtained from the customer through the Internet.
     * @return $this
     */
    public function setStandardEntryClassCodes($standardEntryClassCodes)
    {
        $this->container['standardEntryClassCodes'] = $standardEntryClassCodes;

        return $this;
    }

    /**
     * Gets enableHold
     * @return bool
     */
    public function getEnableHold()
    {
        return $this->container['enableHold'];
    }

    /**
     * Sets enableHold
     * @param bool $enableHold Mandatory  Determines whether CYBS has placed the merchant on a funding hold This will often be set to True for new merchants until the risk team has completed additional verification of their first transaction. It will be switched to \"false\" once underwriting review is completed and we are ready to start funding the merchant.
     * @return $this
     */
    public function setEnableHold($enableHold)
    {
        $this->container['enableHold'] = $enableHold;

        return $this;
    }

    /**
     * Gets monthlyTotalTransactionAmountLimit
     * @return float
     */
    public function getMonthlyTotalTransactionAmountLimit()
    {
        return $this->container['monthlyTotalTransactionAmountLimit'];
    }

    /**
     * Sets monthlyTotalTransactionAmountLimit
     * @param float $monthlyTotalTransactionAmountLimit Mandatory  Monthly Maximum total Transaction Amount 12 digit including decimal
     * @return $this
     */
    public function setMonthlyTotalTransactionAmountLimit($monthlyTotalTransactionAmountLimit)
    {
        $this->container['monthlyTotalTransactionAmountLimit'] = $monthlyTotalTransactionAmountLimit;

        return $this;
    }

    /**
     * Gets holdingDays
     * @return float
     */
    public function getHoldingDays()
    {
        return $this->container['holdingDays'];
    }

    /**
     * Sets holdingDays
     * @param float $holdingDays Mandatory  Funds Hold Days (Number of days funds will be held before it will be deposited into merchant account) 3 digits
     * @return $this
     */
    public function setHoldingDays($holdingDays)
    {
        $this->container['holdingDays'] = $holdingDays;

        return $this;
    }

    /**
     * Gets enableCredits
     * @return bool
     */
    public function getEnableCredits()
    {
        return $this->container['enableCredits'];
    }

    /**
     * Sets enableCredits
     * @param bool $enableCredits Optional  Allow Credits (True/False)
     * @return $this
     */
    public function setEnableCredits($enableCredits)
    {
        $this->container['enableCredits'] = $enableCredits;

        return $this;
    }

    /**
     * Gets transactionAmountLimit
     * @return float
     */
    public function getTransactionAmountLimit()
    {
        return $this->container['transactionAmountLimit'];
    }

    /**
     * Sets transactionAmountLimit
     * @param float $transactionAmountLimit Mandatory  Maximum total Transaction Amount This is a per transaction limit. For example, the merchant is limited to processing transactions under $100 12 digits (including decimal - USD only)
     * @return $this
     */
    public function setTransactionAmountLimit($transactionAmountLimit)
    {
        $this->container['transactionAmountLimit'] = $transactionAmountLimit;

        return $this;
    }

    /**
     * Gets riskReserveMethod
     * @return string
     */
    public function getRiskReserveMethod()
    {
        return $this->container['riskReserveMethod'];
    }

    /**
     * Sets riskReserveMethod
     * @param string $riskReserveMethod Mandatory Reserve Method  Possible value: - fixed - none Most merchants do not have a reserve attached to their account so the default value would be \"none.\"   For a Fixed Reserve, the reserve balance is established by either, (1) a receipt of a lump sum deposit from a merchant, or (2) withholding funds at a Reserve Rate established for the account from each batch settlement until the reserve balance is equal to a set Reserve Target. A Fixed Reserve may also be established by a combination of lump sum deposit and withholding of settlement funds.  A Rolling Reserve balance is established by withholding from a merchant's available settlement funds at a Reserve Rate (percentage) and no Reserve Target is specified. Rather, each amount withheld is retained for a specified number of Reserve Holding Days and then released back to the merchant.
     * @return $this
     */
    public function setRiskReserveMethod($riskReserveMethod)
    {
        $this->container['riskReserveMethod'] = $riskReserveMethod;

        return $this;
    }

    /**
     * Gets riskReserveRate
     * @return float
     */
    public function getRiskReserveRate()
    {
        return $this->container['riskReserveRate'];
    }

    /**
     * Sets riskReserveRate
     * @param float $riskReserveRate Mandatory  Reserve Rate (% of TPV)=> Relevant for Rolling Reserve and Fixed Reserve The percentage rate at which risk funds are withheld from each eCheck.Net batch settlement.
     * @return $this
     */
    public function setRiskReserveRate($riskReserveRate)
    {
        $this->container['riskReserveRate'] = $riskReserveRate;

        return $this;
    }

    /**
     * Gets riskReserveTargetAmount
     * @return float
     */
    public function getRiskReserveTargetAmount()
    {
        return $this->container['riskReserveTargetAmount'];
    }

    /**
     * Sets riskReserveTargetAmount
     * @param float $riskReserveTargetAmount Mandatory  Reserve Target (fixed $ amount)=> Relevant for Fixed Reserve ONLY  The maximum dollar amount that can be held in Risk Reserve for a fixed reserve. Once risk withholdings reach the Reserve Target established for the eCheck.Net account, a portion of available funds will be deposited to the merchant's bank account 12 digit including decimal
     * @return $this
     */
    public function setRiskReserveTargetAmount($riskReserveTargetAmount)
    {
        $this->container['riskReserveTargetAmount'] = $riskReserveTargetAmount;

        return $this;
    }

    /**
     * Gets solutionOrganizationId
     * @return string
     */
    public function getSolutionOrganizationId()
    {
        return $this->container['solutionOrganizationId'];
    }

    /**
     * Sets solutionOrganizationId
     * @param string $solutionOrganizationId Solution organization id
     * @return $this
     */
    public function setSolutionOrganizationId($solutionOrganizationId)
    {
        $this->container['solutionOrganizationId'] = $solutionOrganizationId;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


