<?php
/**
 * GenerateCaptureContextRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * GenerateCaptureContextRequest Class Doc Comment
 *
 * @category    Class
 * @description This is a server-to-server API request to generate the capture context that can be used to initiate an instance of Microform on an acceptance page.   The capture context is a digitally signed JWT that provides authentication, one-time keys, and the target origin to the Microform Integration application.
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class GenerateCaptureContextRequest implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'generateCaptureContextRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'clientVersion' => 'string',
        'targetOrigins' => 'string[]',
        'allowedCardNetworks' => 'string[]',
        'allowedPaymentTypes' => 'string[]',
        'transientTokenResponseOptions' => '\CyberSource\Model\Microformv2sessionsTransientTokenResponseOptions'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'clientVersion' => null,
        'targetOrigins' => null,
        'allowedCardNetworks' => null,
        'allowedPaymentTypes' => null,
        'transientTokenResponseOptions' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'clientVersion' => 'clientVersion',
        'targetOrigins' => 'targetOrigins',
        'allowedCardNetworks' => 'allowedCardNetworks',
        'allowedPaymentTypes' => 'allowedPaymentTypes',
        'transientTokenResponseOptions' => 'transientTokenResponseOptions'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'clientVersion' => 'setClientVersion',
        'targetOrigins' => 'setTargetOrigins',
        'allowedCardNetworks' => 'setAllowedCardNetworks',
        'allowedPaymentTypes' => 'setAllowedPaymentTypes',
        'transientTokenResponseOptions' => 'setTransientTokenResponseOptions'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'clientVersion' => 'getClientVersion',
        'targetOrigins' => 'getTargetOrigins',
        'allowedCardNetworks' => 'getAllowedCardNetworks',
        'allowedPaymentTypes' => 'getAllowedPaymentTypes',
        'transientTokenResponseOptions' => 'getTransientTokenResponseOptions'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['clientVersion'] = isset($data['clientVersion']) ? $data['clientVersion'] : null;
        $this->container['targetOrigins'] = isset($data['targetOrigins']) ? $data['targetOrigins'] : null;
        $this->container['allowedCardNetworks'] = isset($data['allowedCardNetworks']) ? $data['allowedCardNetworks'] : null;
        $this->container['allowedPaymentTypes'] = isset($data['allowedPaymentTypes']) ? $data['allowedPaymentTypes'] : null;
        $this->container['transientTokenResponseOptions'] = isset($data['transientTokenResponseOptions']) ? $data['transientTokenResponseOptions'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets clientVersion
     * @return string
     */
    public function getClientVersion()
    {
        return $this->container['clientVersion'];
    }

    /**
     * Sets clientVersion
     * @param string $clientVersion Specify the version of Microform that you want to use.
     * @return $this
     */
    public function setClientVersion($clientVersion)
    {
        $this->container['clientVersion'] = $clientVersion;

        return $this;
    }

    /**
     * Gets targetOrigins
     * @return string[]
     */
    public function getTargetOrigins()
    {
        return $this->container['targetOrigins'];
    }

    /**
     * Sets targetOrigins
     * @param string[] $targetOrigins The [target origin](https://developer.mozilla.org/en-US/docs/Glossary/Origin) of the website on which you will be launching Microform is defined by the scheme (protocol), hostname (domain) and port number (if used).    You must use https://hostname (unless you use http://localhost) Wildcards are NOT supported.  Ensure that subdomains are included. Any valid top-level domain is supported (e.g. .com, .co.uk, .gov.br etc)  Examples:   - https://example.com   - https://subdomain.example.com   - https://example.com:8080<br><br>  If you are embedding within multiple nested iframes you need to specify the origins of all the browser contexts used, for example:    targetOrigins: [     \"https://example.com\",     \"https://basket.example.com\",     \"https://ecom.example.com\"   ]<br><br>  You can supply up to nine origins within the targetOrigins field for nested iframes. If the list of origins exceeds five ensure that you:   - Compare the list of origins in the v2/sessions targetOrigins field against the location.ancestorOrigins of the browser.    - Ensure that the count of origins and their content matches in both.  If any origins are absent or mismatched, the system will prevent Microform from loading and display a client-side error message.
     * @return $this
     */
    public function setTargetOrigins($targetOrigins)
    {
        $this->container['targetOrigins'] = $targetOrigins;

        return $this;
    }

    /**
     * Gets allowedCardNetworks
     * @return string[]
     */
    public function getAllowedCardNetworks()
    {
        return $this->container['allowedCardNetworks'];
    }

    /**
     * Sets allowedCardNetworks
     * @param string[] $allowedCardNetworks The list of card networks you want to use for this Microform transaction.  Microform currently supports the following card networks: - VISA - MASTERCARD - AMEX - CARNET - CARTESBANCAIRES - CUP - DINERSCLUB - DISCOVER - EFTPOS - ELO - JCB - JCREW - MADA - MAESTRO - MEEZA - PAYPAK  **Important:**    - When integrating Microform (Card) at least one card network should be specified in the allowedCardNetworks field in the capture context request.   - When integrating Microform (ACH/eCheck) the allowedCardNetworks field is not required in the capture context request.   - When integrating both Microform (Card) and Microform (ACH/eCheck) at least one card network should be specified in the allowedCardNetworks field in the capture context request.
     * @return $this
     */
    public function setAllowedCardNetworks($allowedCardNetworks)
    {
        $this->container['allowedCardNetworks'] = $allowedCardNetworks;

        return $this;
    }

    /**
     * Gets allowedPaymentTypes
     * @return string[]
     */
    public function getAllowedPaymentTypes()
    {
        return $this->container['allowedPaymentTypes'];
    }

    /**
     * Sets allowedPaymentTypes
     * @param string[] $allowedPaymentTypes The payment types that are allowed for the merchant.    Possible values when launching Microform: - CARD - CHECK <br><br>
     * @return $this
     */
    public function setAllowedPaymentTypes($allowedPaymentTypes)
    {
        $this->container['allowedPaymentTypes'] = $allowedPaymentTypes;

        return $this;
    }

    /**
     * Gets transientTokenResponseOptions
     * @return \CyberSource\Model\Microformv2sessionsTransientTokenResponseOptions
     */
    public function getTransientTokenResponseOptions()
    {
        return $this->container['transientTokenResponseOptions'];
    }

    /**
     * Sets transientTokenResponseOptions
     * @param \CyberSource\Model\Microformv2sessionsTransientTokenResponseOptions $transientTokenResponseOptions
     * @return $this
     */
    public function setTransientTokenResponseOptions($transientTokenResponseOptions)
    {
        $this->container['transientTokenResponseOptions'] = $transientTokenResponseOptions;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


