<?php
/**
 * Notificationsubscriptionsv2webhooksRetryPolicy
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * Notificationsubscriptionsv2webhooksRetryPolicy Class Doc Comment
 *
 * @category    Class
 * @description Retry policy for the individual webhooks that are a part of your subscription. If a message fails to deliver, it will execute through this retry policy.  Automatic suspend and resume:  If you experience downtime and have &#x60;deactivateFlag &#x3D; true&#x60; any new messages will be held in a \&quot;SUSPENDED\&quot; status. When your healthCheckUrl returns healthy again, the subscription will automatically be re-enabled and your messages will be sent. We will ping your healthCheckUrl routinely using a POST call with an empty payload to check availability. If your endpoint returns an unhealthy status of !&#x3D; 200, we will check the healthCheckUrl at a more frequent rate until it is healthy again.  If you experience downtime and have &#x60;deactivateFlag &#x3D; false&#x60; and your message exhausts all retry attempts the message will go to a \&quot;FAILED\&quot; status. Support will be notified and will reach out to suggest you execute the \&quot;REPLAY\&quot; endpoint at a later date when your server is healthy.   Reference the below values for formulas and calculations related to the frequency of retries depending on algorithm and configuration.
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Notificationsubscriptionsv2webhooksRetryPolicy implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'notificationsubscriptionsv2webhooks_retryPolicy';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'algorithm' => 'string',
        'firstRetry' => 'int',
        'interval' => 'int',
        'numberOfRetries' => 'int',
        'deactivateFlag' => 'string',
        'repeatSequenceCount' => 'int',
        'repeatSequenceWaitTime' => 'int',
        'additionalAttributes' => 'map[string,string][]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'algorithm' => null,
        'firstRetry' => null,
        'interval' => null,
        'numberOfRetries' => null,
        'deactivateFlag' => null,
        'repeatSequenceCount' => null,
        'repeatSequenceWaitTime' => null,
        'additionalAttributes' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'algorithm' => 'algorithm',
        'firstRetry' => 'firstRetry',
        'interval' => 'interval',
        'numberOfRetries' => 'numberOfRetries',
        'deactivateFlag' => 'deactivateFlag',
        'repeatSequenceCount' => 'repeatSequenceCount',
        'repeatSequenceWaitTime' => 'repeatSequenceWaitTime',
        'additionalAttributes' => 'additionalAttributes'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'algorithm' => 'setAlgorithm',
        'firstRetry' => 'setFirstRetry',
        'interval' => 'setInterval',
        'numberOfRetries' => 'setNumberOfRetries',
        'deactivateFlag' => 'setDeactivateFlag',
        'repeatSequenceCount' => 'setRepeatSequenceCount',
        'repeatSequenceWaitTime' => 'setRepeatSequenceWaitTime',
        'additionalAttributes' => 'setAdditionalAttributes'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'algorithm' => 'getAlgorithm',
        'firstRetry' => 'getFirstRetry',
        'interval' => 'getInterval',
        'numberOfRetries' => 'getNumberOfRetries',
        'deactivateFlag' => 'getDeactivateFlag',
        'repeatSequenceCount' => 'getRepeatSequenceCount',
        'repeatSequenceWaitTime' => 'getRepeatSequenceWaitTime',
        'additionalAttributes' => 'getAdditionalAttributes'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['algorithm'] = isset($data['algorithm']) ? $data['algorithm'] : null;
        $this->container['firstRetry'] = isset($data['firstRetry']) ? $data['firstRetry'] : null;
        $this->container['interval'] = isset($data['interval']) ? $data['interval'] : null;
        $this->container['numberOfRetries'] = isset($data['numberOfRetries']) ? $data['numberOfRetries'] : null;
        $this->container['deactivateFlag'] = isset($data['deactivateFlag']) ? $data['deactivateFlag'] : null;
        $this->container['repeatSequenceCount'] = isset($data['repeatSequenceCount']) ? $data['repeatSequenceCount'] : null;
        $this->container['repeatSequenceWaitTime'] = isset($data['repeatSequenceWaitTime']) ? $data['repeatSequenceWaitTime'] : null;
        $this->container['additionalAttributes'] = isset($data['additionalAttributes']) ? $data['additionalAttributes'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets algorithm
     * @return string
     */
    public function getAlgorithm()
    {
        return $this->container['algorithm'];
    }

    /**
     * Sets algorithm
     * @param string $algorithm This is used to calculate the Retry Sequence.  Sample calculations using firstRetry=10, interval=30, maxNumberOfRetries=3 Arithmetic = a+r(n-1) Retry 1 - 10 minutes Retry 2 - 10+30x1 = 40 minutes Retry 3 - 10+30x2 = 70 minutes  Geometric = ar^(n-1) Retry 1 - 10 minutes Retry 2 - 10x30^1 = 300 minutes Retry 3 - 10x30^2 = 9,000 minutes
     * @return $this
     */
    public function setAlgorithm($algorithm)
    {
        $this->container['algorithm'] = $algorithm;

        return $this;
    }

    /**
     * Gets firstRetry
     * @return int
     */
    public function getFirstRetry()
    {
        return $this->container['firstRetry'];
    }

    /**
     * Sets firstRetry
     * @param int $firstRetry When to initiate first retry, after the initial call failed. (in mins).
     * @return $this
     */
    public function setFirstRetry($firstRetry)
    {
        $this->container['firstRetry'] = $firstRetry;

        return $this;
    }

    /**
     * Gets interval
     * @return int
     */
    public function getInterval()
    {
        return $this->container['interval'];
    }

    /**
     * Sets interval
     * @param int $interval The interval between retries (in mins).
     * @return $this
     */
    public function setInterval($interval)
    {
        $this->container['interval'] = $interval;

        return $this;
    }

    /**
     * Gets numberOfRetries
     * @return int
     */
    public function getNumberOfRetries()
    {
        return $this->container['numberOfRetries'];
    }

    /**
     * Sets numberOfRetries
     * @param int $numberOfRetries The number of retries per sequence.
     * @return $this
     */
    public function setNumberOfRetries($numberOfRetries)
    {
        $this->container['numberOfRetries'] = $numberOfRetries;

        return $this;
    }

    /**
     * Gets deactivateFlag
     * @return string
     */
    public function getDeactivateFlag()
    {
        return $this->container['deactivateFlag'];
    }

    /**
     * Sets deactivateFlag
     * @param string $deactivateFlag Deactivate the subscription if your retries fail to deliver.  If this is set to `true`, the automatic suspend and resume feature will occur. This would prevent new webhooks from attempting to deliver and to queue up until your healthCheckUrl returns 200 again, then all messages will be sent.  If this is set to `false`, new individual messages will continue to retry and exhaust all failures, but the subscription will stay active.
     * @return $this
     */
    public function setDeactivateFlag($deactivateFlag)
    {
        $this->container['deactivateFlag'] = $deactivateFlag;

        return $this;
    }

    /**
     * Gets repeatSequenceCount
     * @return int
     */
    public function getRepeatSequenceCount()
    {
        return $this->container['repeatSequenceCount'];
    }

    /**
     * Sets repeatSequenceCount
     * @param int $repeatSequenceCount The number of times to repeat the complete retry sequence. 0 => don't repeat the retry sequence 1 => repeat the retry sequence once (R1, R2, R3)+ (R1, R2, R3) 2 => repeat the retry sequence twice (R1, R2, R3) + (R1, R2, R3) + (R1, R2, R3)
     * @return $this
     */
    public function setRepeatSequenceCount($repeatSequenceCount)
    {
        $this->container['repeatSequenceCount'] = $repeatSequenceCount;

        return $this;
    }

    /**
     * Gets repeatSequenceWaitTime
     * @return int
     */
    public function getRepeatSequenceWaitTime()
    {
        return $this->container['repeatSequenceWaitTime'];
    }

    /**
     * Sets repeatSequenceWaitTime
     * @param int $repeatSequenceWaitTime The time to wait to before repeating the complete retry sequence. Amount of time to wait between each sequence. Sample calculation using repeatSequenceWaitTime=10 (R1, R2, R3) + (10) + (R1, R2, R3) + (10) + (R1, R2, R3)
     * @return $this
     */
    public function setRepeatSequenceWaitTime($repeatSequenceWaitTime)
    {
        $this->container['repeatSequenceWaitTime'] = $repeatSequenceWaitTime;

        return $this;
    }

    /**
     * Gets additionalAttributes
     * @return map[string,string][]
     */
    public function getAdditionalAttributes()
    {
        return $this->container['additionalAttributes'];
    }

    /**
     * Sets additionalAttributes
     * @param map[string,string][] $additionalAttributes Additional data, if any.
     * @return $this
     */
    public function setAdditionalAttributes($additionalAttributes)
    {
        $this->container['additionalAttributes'] = $additionalAttributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


