<?php
/**
 * Ptsv2paymentsOrderInformationLineItems
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * Ptsv2paymentsOrderInformationLineItems Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Ptsv2paymentsOrderInformationLineItems implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ptsv2payments_orderInformation_lineItems';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'productCode' => 'string',
        'productName' => 'string',
        'productSku' => 'string',
        'quantity' => 'int',
        'unitPrice' => 'string',
        'unitOfMeasure' => 'string',
        'totalAmount' => 'string',
        'taxAmount' => 'string',
        'taxRate' => 'string',
        'taxAppliedAfterDiscount' => 'string',
        'taxStatusIndicator' => 'string',
        'taxTypeCode' => 'string',
        'amountIncludesTax' => 'bool',
        'typeOfSupply' => 'string',
        'commodityCode' => 'string',
        'discountAmount' => 'string',
        'discountApplied' => 'bool',
        'discountRate' => 'string',
        'invoiceNumber' => 'string',
        'taxDetails' => '\CyberSource\Model\Ptsv2paymentsOrderInformationAmountDetailsTaxDetails[]',
        'fulfillmentType' => 'string',
        'weight' => 'string',
        'weightIdentifier' => 'string',
        'weightUnit' => 'string',
        'referenceDataCode' => 'string',
        'referenceDataNumber' => 'string',
        'unitTaxAmount' => 'string',
        'productDescription' => 'string',
        'giftCardCurrency' => 'int',
        'shippingDestinationTypes' => 'string',
        'gift' => 'bool',
        'passenger' => '\CyberSource\Model\Ptsv2paymentsOrderInformationPassenger',
        'allowedExportCountries' => 'string[]',
        'restrictedExportCountries' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'productCode' => null,
        'productName' => null,
        'productSku' => null,
        'quantity' => null,
        'unitPrice' => null,
        'unitOfMeasure' => null,
        'totalAmount' => null,
        'taxAmount' => null,
        'taxRate' => null,
        'taxAppliedAfterDiscount' => null,
        'taxStatusIndicator' => null,
        'taxTypeCode' => null,
        'amountIncludesTax' => null,
        'typeOfSupply' => null,
        'commodityCode' => null,
        'discountAmount' => null,
        'discountApplied' => null,
        'discountRate' => null,
        'invoiceNumber' => null,
        'taxDetails' => null,
        'fulfillmentType' => null,
        'weight' => null,
        'weightIdentifier' => null,
        'weightUnit' => null,
        'referenceDataCode' => null,
        'referenceDataNumber' => null,
        'unitTaxAmount' => null,
        'productDescription' => null,
        'giftCardCurrency' => null,
        'shippingDestinationTypes' => null,
        'gift' => null,
        'passenger' => null,
        'allowedExportCountries' => null,
        'restrictedExportCountries' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'productCode' => 'productCode',
        'productName' => 'productName',
        'productSku' => 'productSku',
        'quantity' => 'quantity',
        'unitPrice' => 'unitPrice',
        'unitOfMeasure' => 'unitOfMeasure',
        'totalAmount' => 'totalAmount',
        'taxAmount' => 'taxAmount',
        'taxRate' => 'taxRate',
        'taxAppliedAfterDiscount' => 'taxAppliedAfterDiscount',
        'taxStatusIndicator' => 'taxStatusIndicator',
        'taxTypeCode' => 'taxTypeCode',
        'amountIncludesTax' => 'amountIncludesTax',
        'typeOfSupply' => 'typeOfSupply',
        'commodityCode' => 'commodityCode',
        'discountAmount' => 'discountAmount',
        'discountApplied' => 'discountApplied',
        'discountRate' => 'discountRate',
        'invoiceNumber' => 'invoiceNumber',
        'taxDetails' => 'taxDetails',
        'fulfillmentType' => 'fulfillmentType',
        'weight' => 'weight',
        'weightIdentifier' => 'weightIdentifier',
        'weightUnit' => 'weightUnit',
        'referenceDataCode' => 'referenceDataCode',
        'referenceDataNumber' => 'referenceDataNumber',
        'unitTaxAmount' => 'unitTaxAmount',
        'productDescription' => 'productDescription',
        'giftCardCurrency' => 'giftCardCurrency',
        'shippingDestinationTypes' => 'shippingDestinationTypes',
        'gift' => 'gift',
        'passenger' => 'passenger',
        'allowedExportCountries' => 'allowedExportCountries',
        'restrictedExportCountries' => 'restrictedExportCountries'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'productCode' => 'setProductCode',
        'productName' => 'setProductName',
        'productSku' => 'setProductSku',
        'quantity' => 'setQuantity',
        'unitPrice' => 'setUnitPrice',
        'unitOfMeasure' => 'setUnitOfMeasure',
        'totalAmount' => 'setTotalAmount',
        'taxAmount' => 'setTaxAmount',
        'taxRate' => 'setTaxRate',
        'taxAppliedAfterDiscount' => 'setTaxAppliedAfterDiscount',
        'taxStatusIndicator' => 'setTaxStatusIndicator',
        'taxTypeCode' => 'setTaxTypeCode',
        'amountIncludesTax' => 'setAmountIncludesTax',
        'typeOfSupply' => 'setTypeOfSupply',
        'commodityCode' => 'setCommodityCode',
        'discountAmount' => 'setDiscountAmount',
        'discountApplied' => 'setDiscountApplied',
        'discountRate' => 'setDiscountRate',
        'invoiceNumber' => 'setInvoiceNumber',
        'taxDetails' => 'setTaxDetails',
        'fulfillmentType' => 'setFulfillmentType',
        'weight' => 'setWeight',
        'weightIdentifier' => 'setWeightIdentifier',
        'weightUnit' => 'setWeightUnit',
        'referenceDataCode' => 'setReferenceDataCode',
        'referenceDataNumber' => 'setReferenceDataNumber',
        'unitTaxAmount' => 'setUnitTaxAmount',
        'productDescription' => 'setProductDescription',
        'giftCardCurrency' => 'setGiftCardCurrency',
        'shippingDestinationTypes' => 'setShippingDestinationTypes',
        'gift' => 'setGift',
        'passenger' => 'setPassenger',
        'allowedExportCountries' => 'setAllowedExportCountries',
        'restrictedExportCountries' => 'setRestrictedExportCountries'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'productCode' => 'getProductCode',
        'productName' => 'getProductName',
        'productSku' => 'getProductSku',
        'quantity' => 'getQuantity',
        'unitPrice' => 'getUnitPrice',
        'unitOfMeasure' => 'getUnitOfMeasure',
        'totalAmount' => 'getTotalAmount',
        'taxAmount' => 'getTaxAmount',
        'taxRate' => 'getTaxRate',
        'taxAppliedAfterDiscount' => 'getTaxAppliedAfterDiscount',
        'taxStatusIndicator' => 'getTaxStatusIndicator',
        'taxTypeCode' => 'getTaxTypeCode',
        'amountIncludesTax' => 'getAmountIncludesTax',
        'typeOfSupply' => 'getTypeOfSupply',
        'commodityCode' => 'getCommodityCode',
        'discountAmount' => 'getDiscountAmount',
        'discountApplied' => 'getDiscountApplied',
        'discountRate' => 'getDiscountRate',
        'invoiceNumber' => 'getInvoiceNumber',
        'taxDetails' => 'getTaxDetails',
        'fulfillmentType' => 'getFulfillmentType',
        'weight' => 'getWeight',
        'weightIdentifier' => 'getWeightIdentifier',
        'weightUnit' => 'getWeightUnit',
        'referenceDataCode' => 'getReferenceDataCode',
        'referenceDataNumber' => 'getReferenceDataNumber',
        'unitTaxAmount' => 'getUnitTaxAmount',
        'productDescription' => 'getProductDescription',
        'giftCardCurrency' => 'getGiftCardCurrency',
        'shippingDestinationTypes' => 'getShippingDestinationTypes',
        'gift' => 'getGift',
        'passenger' => 'getPassenger',
        'allowedExportCountries' => 'getAllowedExportCountries',
        'restrictedExportCountries' => 'getRestrictedExportCountries'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['productCode'] = isset($data['productCode']) ? $data['productCode'] : null;
        $this->container['productName'] = isset($data['productName']) ? $data['productName'] : null;
        $this->container['productSku'] = isset($data['productSku']) ? $data['productSku'] : null;
        $this->container['quantity'] = isset($data['quantity']) ? $data['quantity'] : null;
        $this->container['unitPrice'] = isset($data['unitPrice']) ? $data['unitPrice'] : null;
        $this->container['unitOfMeasure'] = isset($data['unitOfMeasure']) ? $data['unitOfMeasure'] : null;
        $this->container['totalAmount'] = isset($data['totalAmount']) ? $data['totalAmount'] : null;
        $this->container['taxAmount'] = isset($data['taxAmount']) ? $data['taxAmount'] : null;
        $this->container['taxRate'] = isset($data['taxRate']) ? $data['taxRate'] : null;
        $this->container['taxAppliedAfterDiscount'] = isset($data['taxAppliedAfterDiscount']) ? $data['taxAppliedAfterDiscount'] : null;
        $this->container['taxStatusIndicator'] = isset($data['taxStatusIndicator']) ? $data['taxStatusIndicator'] : null;
        $this->container['taxTypeCode'] = isset($data['taxTypeCode']) ? $data['taxTypeCode'] : null;
        $this->container['amountIncludesTax'] = isset($data['amountIncludesTax']) ? $data['amountIncludesTax'] : null;
        $this->container['typeOfSupply'] = isset($data['typeOfSupply']) ? $data['typeOfSupply'] : null;
        $this->container['commodityCode'] = isset($data['commodityCode']) ? $data['commodityCode'] : null;
        $this->container['discountAmount'] = isset($data['discountAmount']) ? $data['discountAmount'] : null;
        $this->container['discountApplied'] = isset($data['discountApplied']) ? $data['discountApplied'] : null;
        $this->container['discountRate'] = isset($data['discountRate']) ? $data['discountRate'] : null;
        $this->container['invoiceNumber'] = isset($data['invoiceNumber']) ? $data['invoiceNumber'] : null;
        $this->container['taxDetails'] = isset($data['taxDetails']) ? $data['taxDetails'] : null;
        $this->container['fulfillmentType'] = isset($data['fulfillmentType']) ? $data['fulfillmentType'] : null;
        $this->container['weight'] = isset($data['weight']) ? $data['weight'] : null;
        $this->container['weightIdentifier'] = isset($data['weightIdentifier']) ? $data['weightIdentifier'] : null;
        $this->container['weightUnit'] = isset($data['weightUnit']) ? $data['weightUnit'] : null;
        $this->container['referenceDataCode'] = isset($data['referenceDataCode']) ? $data['referenceDataCode'] : null;
        $this->container['referenceDataNumber'] = isset($data['referenceDataNumber']) ? $data['referenceDataNumber'] : null;
        $this->container['unitTaxAmount'] = isset($data['unitTaxAmount']) ? $data['unitTaxAmount'] : null;
        $this->container['productDescription'] = isset($data['productDescription']) ? $data['productDescription'] : null;
        $this->container['giftCardCurrency'] = isset($data['giftCardCurrency']) ? $data['giftCardCurrency'] : null;
        $this->container['shippingDestinationTypes'] = isset($data['shippingDestinationTypes']) ? $data['shippingDestinationTypes'] : null;
        $this->container['gift'] = isset($data['gift']) ? $data['gift'] : null;
        $this->container['passenger'] = isset($data['passenger']) ? $data['passenger'] : null;
        $this->container['allowedExportCountries'] = isset($data['allowedExportCountries']) ? $data['allowedExportCountries'] : null;
        $this->container['restrictedExportCountries'] = isset($data['restrictedExportCountries']) ? $data['restrictedExportCountries'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets productCode
     * @return string
     */
    public function getProductCode()
    {
        return $this->container['productCode'];
    }

    /**
     * Sets productCode
     * @param string $productCode Type of product. The value for this field is used to identify the product category (electronic, handling, physical, service, or shipping). The default value is `default`.  If you are performing an authorization transaction (`processingOptions.capture` is set to `false`), and you set this field to a value other than `default` or one of the values related to shipping and/or handling, then `orderInformation.lineItems[].quantity`, `orderInformation.lineItems[].productName`, and `orderInformation.lineItems[].productSku` fields are required.  Optional field.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes.  The Product Codes for the tax service are located in the Cybersource Tax Codes guide. Contact Customer Support to request the guide. If you don't send a tax service Product Code in your tax request, product-based rules or exemptions will not be applied and the transaction will default to fully taxable in the locations where you've indicated you need to collect tax [by way of nexus, no nexus, or seller registration number fields].
     * @return $this
     */
    public function setProductCode($productCode)
    {
        $this->container['productCode'] = $productCode;

        return $this;
    }

    /**
     * Gets productName
     * @return string
     */
    public function getProductName()
    {
        return $this->container['productName'];
    }

    /**
     * Sets productName
     * @param string $productName For an authorization or capture transaction (`processingOptions.capture` is `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes.
     * @return $this
     */
    public function setProductName($productName)
    {
        $this->container['productName'] = $productName;

        return $this;
    }

    /**
     * Gets productSku
     * @return string
     */
    public function getProductSku()
    {
        return $this->container['productSku'];
    }

    /**
     * Sets productSku
     * @param string $productSku Product identifier code. Also known as the Stock Keeping Unit (SKU) code for the product.  For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not set to **default** or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S. and Canadian taxes. Not applicable to international and value added taxes. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the values related to shipping and/or handling.
     * @return $this
     */
    public function setProductSku($productSku)
    {
        $this->container['productSku'] = $productSku;

        return $this;
    }

    /**
     * Gets quantity
     * @return int
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     * @param int $quantity Number of units for this order. Must be a non-negative integer.  The default is `1`. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the other values related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes.
     * @return $this
     */
    public function setQuantity($quantity)
    {
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets unitPrice
     * @return string
     */
    public function getUnitPrice()
    {
        return $this->container['unitPrice'];
    }

    /**
     * Sets unitPrice
     * @param string $unitPrice Per-item price of the product. This value for this field cannot be negative.  You must include either this field or the request-level field `orderInformation.amountDetails.totalAmount` in your request.  You can include a decimal point (.), but you cannot include any other special characters. The value is truncated to the correct number of decimal places.  #### DCC with a Third-Party Provider Set this field to the converted amount that was returned by the DCC provider. You must include either the 1st line item in the order and this field, or the request-level field `orderInformation.amountDetails.totalAmount` in your request.  #### Tax Calculation Required field for U.S., Canadian, international and value added taxes.  #### Zero Amount Authorizations If your processor supports zero amount authorizations, you can set this field to 0 for the authorization to check if the card is lost or stolen.  #### Maximum Field Lengths For GPN and JCN Gateway: Decimal (10) All other processors: Decimal (15)
     * @return $this
     */
    public function setUnitPrice($unitPrice)
    {
        $this->container['unitPrice'] = $unitPrice;

        return $this;
    }

    /**
     * Gets unitOfMeasure
     * @return string
     */
    public function getUnitOfMeasure()
    {
        return $this->container['unitOfMeasure'];
    }

    /**
     * Sets unitOfMeasure
     * @param string $unitOfMeasure Unit of measure, or unit of measure code, for the item.
     * @return $this
     */
    public function setUnitOfMeasure($unitOfMeasure)
    {
        $this->container['unitOfMeasure'] = $unitOfMeasure;

        return $this;
    }

    /**
     * Gets totalAmount
     * @return string
     */
    public function getTotalAmount()
    {
        return $this->container['totalAmount'];
    }

    /**
     * Sets totalAmount
     * @param string $totalAmount Total amount for the item. Normally calculated as the unit price times quantity.  When `orderInformation.lineItems[].productCode` is \"gift_card\", this is the purchase amount total for prepaid gift cards in major units.  Example: 123.45 USD = 123
     * @return $this
     */
    public function setTotalAmount($totalAmount)
    {
        $this->container['totalAmount'] = $totalAmount;

        return $this;
    }

    /**
     * Gets taxAmount
     * @return string
     */
    public function getTaxAmount()
    {
        return $this->container['taxAmount'];
    }

    /**
     * Sets taxAmount
     * @param string $taxAmount Total tax to apply to the product. This value cannot be negative. The tax amount and the offer amount must be in the same currency. The tax amount field is additive.  The following example uses a two-exponent currency such as USD:   1. You include each line item in your request.  ..- 1st line item has amount=10.00, quantity=1, and taxAmount=0.80  ..- 2nd line item has amount=20.00, quantity=1, and taxAmount=1.60  2. The total amount authorized will be 32.40, not 30.00 with 2.40 of tax included.  Optional field.  #### Airlines processing Tax portion of the order amount. This value cannot exceed 99999999999999 (fourteen 9s). Format: English characters only. Optional request field for a line item.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes.  Note if you send this field in your tax request, the value in the field will override the tax engine
     * @return $this
     */
    public function setTaxAmount($taxAmount)
    {
        $this->container['taxAmount'] = $taxAmount;

        return $this;
    }

    /**
     * Gets taxRate
     * @return string
     */
    public function getTaxRate()
    {
        return $this->container['taxRate'];
    }

    /**
     * Sets taxRate
     * @param string $taxRate Tax rate applied to the item.  **Visa**: Valid range is 0.01 to 0.99 (1% to 99%, with only whole percentage values accepted; values with additional decimal places will be truncated).  **Mastercard**: Valid range is 0.00001 to 0.99999 (0.001% to 99.999%).
     * @return $this
     */
    public function setTaxRate($taxRate)
    {
        $this->container['taxRate'] = $taxRate;

        return $this;
    }

    /**
     * Gets taxAppliedAfterDiscount
     * @return string
     */
    public function getTaxAppliedAfterDiscount()
    {
        return $this->container['taxAppliedAfterDiscount'];
    }

    /**
     * Sets taxAppliedAfterDiscount
     * @param string $taxAppliedAfterDiscount Flag to indicate how you handle discount at the line item level.   - 0: no line level discount provided  - 1: tax was calculated on the post-discount line item total  - 2: tax was calculated on the pre-discount line item total  `Note` Visa will inset 0 (zero) if an invalid value is included in this field.  This field relates to the value in the _lineItems[].discountAmount_ field.
     * @return $this
     */
    public function setTaxAppliedAfterDiscount($taxAppliedAfterDiscount)
    {
        $this->container['taxAppliedAfterDiscount'] = $taxAppliedAfterDiscount;

        return $this;
    }

    /**
     * Gets taxStatusIndicator
     * @return string
     */
    public function getTaxStatusIndicator()
    {
        return $this->container['taxStatusIndicator'];
    }

    /**
     * Sets taxStatusIndicator
     * @param string $taxStatusIndicator Flag to indicate whether tax is exempted or not included.   - 0: tax not included  - 1: tax included  - 2: transaction is not subject to tax
     * @return $this
     */
    public function setTaxStatusIndicator($taxStatusIndicator)
    {
        $this->container['taxStatusIndicator'] = $taxStatusIndicator;

        return $this;
    }

    /**
     * Gets taxTypeCode
     * @return string
     */
    public function getTaxTypeCode()
    {
        return $this->container['taxTypeCode'];
    }

    /**
     * Sets taxTypeCode
     * @param string $taxTypeCode Type of tax being applied to the item.  #### FDC Nashville Global - `alternate_tax_type_applied` - `alternate_tax_type_identifier`  #### Worldpay VAP - `alternate_tax_type_identifier`  #### RBS WorldPay Atlanta - `tax_type_applied`  #### TSYS Acquiring Solutions - `tax_type_applied` - `local_tax_indicator`  #### Chase Paymentech Solutions - `tax_type_applied`  #### Elavon Americas - `local_tax_indicator`  #### FDC Compass - `tax_type_applied`  #### OmniPay Direct - `local_tax_indicator`
     * @return $this
     */
    public function setTaxTypeCode($taxTypeCode)
    {
        $this->container['taxTypeCode'] = $taxTypeCode;

        return $this;
    }

    /**
     * Gets amountIncludesTax
     * @return bool
     */
    public function getAmountIncludesTax()
    {
        return $this->container['amountIncludesTax'];
    }

    /**
     * Sets amountIncludesTax
     * @param bool $amountIncludesTax Flag that indicates whether the tax amount is included in the Line Item Total.  Possible values:  - **true**  - **false**
     * @return $this
     */
    public function setAmountIncludesTax($amountIncludesTax)
    {
        $this->container['amountIncludesTax'] = $amountIncludesTax;

        return $this;
    }

    /**
     * Gets typeOfSupply
     * @return string
     */
    public function getTypeOfSupply()
    {
        return $this->container['typeOfSupply'];
    }

    /**
     * Sets typeOfSupply
     * @param string $typeOfSupply Flag to indicate whether the purchase is categorized as goods or services. Possible values:   - 00: goods  - 01: services
     * @return $this
     */
    public function setTypeOfSupply($typeOfSupply)
    {
        $this->container['typeOfSupply'] = $typeOfSupply;

        return $this;
    }

    /**
     * Gets commodityCode
     * @return string
     */
    public function getCommodityCode()
    {
        return $this->container['commodityCode'];
    }

    /**
     * Sets commodityCode
     * @param string $commodityCode Commodity code or International description code used to classify the item. Contact your acquirer for a list of codes.
     * @return $this
     */
    public function setCommodityCode($commodityCode)
    {
        $this->container['commodityCode'] = $commodityCode;

        return $this;
    }

    /**
     * Gets discountAmount
     * @return string
     */
    public function getDiscountAmount()
    {
        return $this->container['discountAmount'];
    }

    /**
     * Sets discountAmount
     * @param string $discountAmount Discount applied to the item.
     * @return $this
     */
    public function setDiscountAmount($discountAmount)
    {
        $this->container['discountAmount'] = $discountAmount;

        return $this;
    }

    /**
     * Gets discountApplied
     * @return bool
     */
    public function getDiscountApplied()
    {
        return $this->container['discountApplied'];
    }

    /**
     * Sets discountApplied
     * @param bool $discountApplied Flag that indicates whether the amount is discounted.  If you do not provide a value but you set Discount Amount to a value greater than zero, then CyberSource sets this field to **true**.  Possible values:  - **true**  - **false**
     * @return $this
     */
    public function setDiscountApplied($discountApplied)
    {
        $this->container['discountApplied'] = $discountApplied;

        return $this;
    }

    /**
     * Gets discountRate
     * @return string
     */
    public function getDiscountRate()
    {
        return $this->container['discountRate'];
    }

    /**
     * Sets discountRate
     * @param string $discountRate Rate the item is discounted. Maximum of 2 decimal places.  Example 5.25 (=5.25%)
     * @return $this
     */
    public function setDiscountRate($discountRate)
    {
        $this->container['discountRate'] = $discountRate;

        return $this;
    }

    /**
     * Gets invoiceNumber
     * @return string
     */
    public function getInvoiceNumber()
    {
        return $this->container['invoiceNumber'];
    }

    /**
     * Sets invoiceNumber
     * @param string $invoiceNumber Field to support an invoice number for a transaction. You must specify the number of line items that will include an invoice number. By default, the first line item will include an invoice number field. The invoice number field can be included for up to 10 line items.
     * @return $this
     */
    public function setInvoiceNumber($invoiceNumber)
    {
        $this->container['invoiceNumber'] = $invoiceNumber;

        return $this;
    }

    /**
     * Gets taxDetails
     * @return \CyberSource\Model\Ptsv2paymentsOrderInformationAmountDetailsTaxDetails[]
     */
    public function getTaxDetails()
    {
        return $this->container['taxDetails'];
    }

    /**
     * Sets taxDetails
     * @param \CyberSource\Model\Ptsv2paymentsOrderInformationAmountDetailsTaxDetails[] $taxDetails
     * @return $this
     */
    public function setTaxDetails($taxDetails)
    {
        $this->container['taxDetails'] = $taxDetails;

        return $this;
    }

    /**
     * Gets fulfillmentType
     * @return string
     */
    public function getFulfillmentType()
    {
        return $this->container['fulfillmentType'];
    }

    /**
     * Sets fulfillmentType
     * @param string $fulfillmentType Information about the product code used for the line item. Possible values: - `E`: The product code is `electronic_software`. - `P`: The product code is not `electronic_software`.  For details, see the `fulfillmentType` field description in [Business Center Reporting User Guide.] (https://apps.cybersource.com/library/documentation/dev_guides/reporting_and_reconciliation/Reporting_User/html/)
     * @return $this
     */
    public function setFulfillmentType($fulfillmentType)
    {
        $this->container['fulfillmentType'] = $fulfillmentType;

        return $this;
    }

    /**
     * Gets weight
     * @return string
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     * @param string $weight Weight of the item.
     * @return $this
     */
    public function setWeight($weight)
    {
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets weightIdentifier
     * @return string
     */
    public function getWeightIdentifier()
    {
        return $this->container['weightIdentifier'];
    }

    /**
     * Sets weightIdentifier
     * @param string $weightIdentifier Type of weight.  Possible values: - B: Billed weight - N: Actual net weight
     * @return $this
     */
    public function setWeightIdentifier($weightIdentifier)
    {
        $this->container['weightIdentifier'] = $weightIdentifier;

        return $this;
    }

    /**
     * Gets weightUnit
     * @return string
     */
    public function getWeightUnit()
    {
        return $this->container['weightUnit'];
    }

    /**
     * Sets weightUnit
     * @param string $weightUnit Code that specifies the unit of measurement for the weight amount. For example, `OZ` specifies ounce and `LB` specifies pound. The possible values are defined by the ANSI Accredited Standards Committee (ASC).
     * @return $this
     */
    public function setWeightUnit($weightUnit)
    {
        $this->container['weightUnit'] = $weightUnit;

        return $this;
    }

    /**
     * Gets referenceDataCode
     * @return string
     */
    public function getReferenceDataCode()
    {
        return $this->container['referenceDataCode'];
    }

    /**
     * Sets referenceDataCode
     * @param string $referenceDataCode Code that identifies the value of the corresponding `orderInformation.lineItems[].referenceDataNumber` field.  Possible values: - AN: Client-defined asset code - MG: Manufacturer's part number - PO: Purchase order number - SK: Supplier stock keeping unit number - UP: Universal product code - VC: Supplier catalog number - VP: Vendor part number  This field is a pass-through, which means that CyberSource does not verify the value or modify it in any way before sending it to the processor.
     * @return $this
     */
    public function setReferenceDataCode($referenceDataCode)
    {
        $this->container['referenceDataCode'] = $referenceDataCode;

        return $this;
    }

    /**
     * Gets referenceDataNumber
     * @return string
     */
    public function getReferenceDataNumber()
    {
        return $this->container['referenceDataNumber'];
    }

    /**
     * Sets referenceDataNumber
     * @param string $referenceDataNumber Reference number.  The meaning of this value is identified by the value of the corresponding `referenceDataCode` field. See Numbered Elements.  The maximum length for this field depends on the value of the corresponding `referenceDataCode` field: - When the code is `PO`, the maximum length for the reference number is 22. - When the code is `VC`, the maximum length for the reference number is 20. - For all other codes, the maximum length for the reference number is 30.  This field is a pass-through, which means that CyberSource does not verify the value or modify it in any way before sending it to the processor.
     * @return $this
     */
    public function setReferenceDataNumber($referenceDataNumber)
    {
        $this->container['referenceDataNumber'] = $referenceDataNumber;

        return $this;
    }

    /**
     * Gets unitTaxAmount
     * @return string
     */
    public function getUnitTaxAmount()
    {
        return $this->container['unitTaxAmount'];
    }

    /**
     * Sets unitTaxAmount
     * @param string $unitTaxAmount Per-item tax amount of the product. Note The amount value must be a non-negative number containing 2 decimal places and limited to 7 digits before the decimal point.
     * @return $this
     */
    public function setUnitTaxAmount($unitTaxAmount)
    {
        $this->container['unitTaxAmount'] = $unitTaxAmount;

        return $this;
    }

    /**
     * Gets productDescription
     * @return string
     */
    public function getProductDescription()
    {
        return $this->container['productDescription'];
    }

    /**
     * Sets productDescription
     * @param string $productDescription Brief description of item.
     * @return $this
     */
    public function setProductDescription($productDescription)
    {
        $this->container['productDescription'] = $productDescription;

        return $this;
    }

    /**
     * Gets giftCardCurrency
     * @return int
     */
    public function getGiftCardCurrency()
    {
        return $this->container['giftCardCurrency'];
    }

    /**
     * Sets giftCardCurrency
     * @param int $giftCardCurrency When `orderInformation.lineItems[].productCode` is \"gift_card\", this is the currency used for the gift card purchase.  For the possible values, see the [ISO Standard Currency Codes.](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf)
     * @return $this
     */
    public function setGiftCardCurrency($giftCardCurrency)
    {
        $this->container['giftCardCurrency'] = $giftCardCurrency;

        return $this;
    }

    /**
     * Gets shippingDestinationTypes
     * @return string
     */
    public function getShippingDestinationTypes()
    {
        return $this->container['shippingDestinationTypes'];
    }

    /**
     * Sets shippingDestinationTypes
     * @param string $shippingDestinationTypes Destination to where the item will be shipped. Example: Commercial, Residential, Store
     * @return $this
     */
    public function setShippingDestinationTypes($shippingDestinationTypes)
    {
        $this->container['shippingDestinationTypes'] = $shippingDestinationTypes;

        return $this;
    }

    /**
     * Gets gift
     * @return bool
     */
    public function getGift()
    {
        return $this->container['gift'];
    }

    /**
     * Sets gift
     * @param bool $gift This field is only used in DM service.  Determines whether to assign risk to the order if the billing and shipping addresses specify different cities, states, or countries. This field can contain one of the following values: - true: Orders are assigned only slight additional risk if billing and shipping addresses are different. - false: Orders are assigned higher additional risk if billing and shipping addresses are different.
     * @return $this
     */
    public function setGift($gift)
    {
        $this->container['gift'] = $gift;

        return $this;
    }

    /**
     * Gets passenger
     * @return \CyberSource\Model\Ptsv2paymentsOrderInformationPassenger
     */
    public function getPassenger()
    {
        return $this->container['passenger'];
    }

    /**
     * Sets passenger
     * @param \CyberSource\Model\Ptsv2paymentsOrderInformationPassenger $passenger
     * @return $this
     */
    public function setPassenger($passenger)
    {
        $this->container['passenger'] = $passenger;

        return $this;
    }

    /**
     * Gets allowedExportCountries
     * @return string[]
     */
    public function getAllowedExportCountries()
    {
        return $this->container['allowedExportCountries'];
    }

    /**
     * Sets allowedExportCountries
     * @param string[] $allowedExportCountries
     * @return $this
     */
    public function setAllowedExportCountries($allowedExportCountries)
    {
        $this->container['allowedExportCountries'] = $allowedExportCountries;

        return $this;
    }

    /**
     * Gets restrictedExportCountries
     * @return string[]
     */
    public function getRestrictedExportCountries()
    {
        return $this->container['restrictedExportCountries'];
    }

    /**
     * Sets restrictedExportCountries
     * @param string[] $restrictedExportCountries
     * @return $this
     */
    public function setRestrictedExportCountries($restrictedExportCountries)
    {
        $this->container['restrictedExportCountries'] = $restrictedExportCountries;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


