<?php
/**
 * Ptsv2paymentsPointOfSaleInformation
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * Ptsv2paymentsPointOfSaleInformation Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Ptsv2paymentsPointOfSaleInformation implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ptsv2payments_pointOfSaleInformation';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'terminalId' => 'string',
        'terminalSerialNumber' => 'string',
        'cardholderVerificationMethodUsed' => 'int',
        'laneNumber' => 'string',
        'catLevel' => 'int',
        'entryMode' => 'string',
        'terminalCapability' => 'int',
        'operatingEnvironment' => 'string',
        'emv' => '\CyberSource\Model\Ptsv2paymentsPointOfSaleInformationEmv',
        'amexCapnData' => 'string',
        'trackData' => 'string',
        'storeAndForwardIndicator' => 'string',
        'cardholderVerificationMethod' => 'string[]',
        'terminalCategory' => 'string',
        'terminalInputCapability' => 'string[]',
        'terminalCardCaptureCapability' => 'string',
        'terminalOutputCapability' => 'string',
        'terminalPinCapability' => 'int',
        'pinEntrySolution' => 'string',
        'deviceId' => 'string',
        'pinBlockEncodingFormat' => 'int',
        'encryptedPin' => 'string',
        'encryptedKeySerialNumber' => 'string',
        'partnerSdkVersion' => 'string',
        'emvApplicationIdentifierAndDedicatedFileName' => 'string',
        'terminalCompliance' => 'string',
        'isDedicatedHardwareTerminal' => 'string',
        'terminalModel' => 'string',
        'terminalMake' => 'string',
        'serviceCode' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'terminalId' => null,
        'terminalSerialNumber' => null,
        'cardholderVerificationMethodUsed' => null,
        'laneNumber' => null,
        'catLevel' => null,
        'entryMode' => null,
        'terminalCapability' => null,
        'operatingEnvironment' => null,
        'emv' => null,
        'amexCapnData' => null,
        'trackData' => null,
        'storeAndForwardIndicator' => null,
        'cardholderVerificationMethod' => null,
        'terminalCategory' => null,
        'terminalInputCapability' => null,
        'terminalCardCaptureCapability' => null,
        'terminalOutputCapability' => null,
        'terminalPinCapability' => null,
        'pinEntrySolution' => null,
        'deviceId' => null,
        'pinBlockEncodingFormat' => null,
        'encryptedPin' => null,
        'encryptedKeySerialNumber' => null,
        'partnerSdkVersion' => null,
        'emvApplicationIdentifierAndDedicatedFileName' => null,
        'terminalCompliance' => null,
        'isDedicatedHardwareTerminal' => null,
        'terminalModel' => null,
        'terminalMake' => null,
        'serviceCode' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'terminalId' => 'terminalId',
        'terminalSerialNumber' => 'terminalSerialNumber',
        'cardholderVerificationMethodUsed' => 'cardholderVerificationMethodUsed',
        'laneNumber' => 'laneNumber',
        'catLevel' => 'catLevel',
        'entryMode' => 'entryMode',
        'terminalCapability' => 'terminalCapability',
        'operatingEnvironment' => 'operatingEnvironment',
        'emv' => 'emv',
        'amexCapnData' => 'amexCapnData',
        'trackData' => 'trackData',
        'storeAndForwardIndicator' => 'storeAndForwardIndicator',
        'cardholderVerificationMethod' => 'cardholderVerificationMethod',
        'terminalCategory' => 'terminalCategory',
        'terminalInputCapability' => 'terminalInputCapability',
        'terminalCardCaptureCapability' => 'terminalCardCaptureCapability',
        'terminalOutputCapability' => 'terminalOutputCapability',
        'terminalPinCapability' => 'terminalPinCapability',
        'pinEntrySolution' => 'pinEntrySolution',
        'deviceId' => 'deviceId',
        'pinBlockEncodingFormat' => 'pinBlockEncodingFormat',
        'encryptedPin' => 'encryptedPin',
        'encryptedKeySerialNumber' => 'encryptedKeySerialNumber',
        'partnerSdkVersion' => 'partnerSdkVersion',
        'emvApplicationIdentifierAndDedicatedFileName' => 'emvApplicationIdentifierAndDedicatedFileName',
        'terminalCompliance' => 'terminalCompliance',
        'isDedicatedHardwareTerminal' => 'isDedicatedHardwareTerminal',
        'terminalModel' => 'terminalModel',
        'terminalMake' => 'terminalMake',
        'serviceCode' => 'serviceCode'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'terminalId' => 'setTerminalId',
        'terminalSerialNumber' => 'setTerminalSerialNumber',
        'cardholderVerificationMethodUsed' => 'setCardholderVerificationMethodUsed',
        'laneNumber' => 'setLaneNumber',
        'catLevel' => 'setCatLevel',
        'entryMode' => 'setEntryMode',
        'terminalCapability' => 'setTerminalCapability',
        'operatingEnvironment' => 'setOperatingEnvironment',
        'emv' => 'setEmv',
        'amexCapnData' => 'setAmexCapnData',
        'trackData' => 'setTrackData',
        'storeAndForwardIndicator' => 'setStoreAndForwardIndicator',
        'cardholderVerificationMethod' => 'setCardholderVerificationMethod',
        'terminalCategory' => 'setTerminalCategory',
        'terminalInputCapability' => 'setTerminalInputCapability',
        'terminalCardCaptureCapability' => 'setTerminalCardCaptureCapability',
        'terminalOutputCapability' => 'setTerminalOutputCapability',
        'terminalPinCapability' => 'setTerminalPinCapability',
        'pinEntrySolution' => 'setPinEntrySolution',
        'deviceId' => 'setDeviceId',
        'pinBlockEncodingFormat' => 'setPinBlockEncodingFormat',
        'encryptedPin' => 'setEncryptedPin',
        'encryptedKeySerialNumber' => 'setEncryptedKeySerialNumber',
        'partnerSdkVersion' => 'setPartnerSdkVersion',
        'emvApplicationIdentifierAndDedicatedFileName' => 'setEmvApplicationIdentifierAndDedicatedFileName',
        'terminalCompliance' => 'setTerminalCompliance',
        'isDedicatedHardwareTerminal' => 'setIsDedicatedHardwareTerminal',
        'terminalModel' => 'setTerminalModel',
        'terminalMake' => 'setTerminalMake',
        'serviceCode' => 'setServiceCode'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'terminalId' => 'getTerminalId',
        'terminalSerialNumber' => 'getTerminalSerialNumber',
        'cardholderVerificationMethodUsed' => 'getCardholderVerificationMethodUsed',
        'laneNumber' => 'getLaneNumber',
        'catLevel' => 'getCatLevel',
        'entryMode' => 'getEntryMode',
        'terminalCapability' => 'getTerminalCapability',
        'operatingEnvironment' => 'getOperatingEnvironment',
        'emv' => 'getEmv',
        'amexCapnData' => 'getAmexCapnData',
        'trackData' => 'getTrackData',
        'storeAndForwardIndicator' => 'getStoreAndForwardIndicator',
        'cardholderVerificationMethod' => 'getCardholderVerificationMethod',
        'terminalCategory' => 'getTerminalCategory',
        'terminalInputCapability' => 'getTerminalInputCapability',
        'terminalCardCaptureCapability' => 'getTerminalCardCaptureCapability',
        'terminalOutputCapability' => 'getTerminalOutputCapability',
        'terminalPinCapability' => 'getTerminalPinCapability',
        'pinEntrySolution' => 'getPinEntrySolution',
        'deviceId' => 'getDeviceId',
        'pinBlockEncodingFormat' => 'getPinBlockEncodingFormat',
        'encryptedPin' => 'getEncryptedPin',
        'encryptedKeySerialNumber' => 'getEncryptedKeySerialNumber',
        'partnerSdkVersion' => 'getPartnerSdkVersion',
        'emvApplicationIdentifierAndDedicatedFileName' => 'getEmvApplicationIdentifierAndDedicatedFileName',
        'terminalCompliance' => 'getTerminalCompliance',
        'isDedicatedHardwareTerminal' => 'getIsDedicatedHardwareTerminal',
        'terminalModel' => 'getTerminalModel',
        'terminalMake' => 'getTerminalMake',
        'serviceCode' => 'getServiceCode'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['terminalId'] = isset($data['terminalId']) ? $data['terminalId'] : null;
        $this->container['terminalSerialNumber'] = isset($data['terminalSerialNumber']) ? $data['terminalSerialNumber'] : null;
        $this->container['cardholderVerificationMethodUsed'] = isset($data['cardholderVerificationMethodUsed']) ? $data['cardholderVerificationMethodUsed'] : null;
        $this->container['laneNumber'] = isset($data['laneNumber']) ? $data['laneNumber'] : null;
        $this->container['catLevel'] = isset($data['catLevel']) ? $data['catLevel'] : null;
        $this->container['entryMode'] = isset($data['entryMode']) ? $data['entryMode'] : null;
        $this->container['terminalCapability'] = isset($data['terminalCapability']) ? $data['terminalCapability'] : null;
        $this->container['operatingEnvironment'] = isset($data['operatingEnvironment']) ? $data['operatingEnvironment'] : null;
        $this->container['emv'] = isset($data['emv']) ? $data['emv'] : null;
        $this->container['amexCapnData'] = isset($data['amexCapnData']) ? $data['amexCapnData'] : null;
        $this->container['trackData'] = isset($data['trackData']) ? $data['trackData'] : null;
        $this->container['storeAndForwardIndicator'] = isset($data['storeAndForwardIndicator']) ? $data['storeAndForwardIndicator'] : null;
        $this->container['cardholderVerificationMethod'] = isset($data['cardholderVerificationMethod']) ? $data['cardholderVerificationMethod'] : null;
        $this->container['terminalCategory'] = isset($data['terminalCategory']) ? $data['terminalCategory'] : null;
        $this->container['terminalInputCapability'] = isset($data['terminalInputCapability']) ? $data['terminalInputCapability'] : null;
        $this->container['terminalCardCaptureCapability'] = isset($data['terminalCardCaptureCapability']) ? $data['terminalCardCaptureCapability'] : null;
        $this->container['terminalOutputCapability'] = isset($data['terminalOutputCapability']) ? $data['terminalOutputCapability'] : null;
        $this->container['terminalPinCapability'] = isset($data['terminalPinCapability']) ? $data['terminalPinCapability'] : null;
        $this->container['pinEntrySolution'] = isset($data['pinEntrySolution']) ? $data['pinEntrySolution'] : null;
        $this->container['deviceId'] = isset($data['deviceId']) ? $data['deviceId'] : null;
        $this->container['pinBlockEncodingFormat'] = isset($data['pinBlockEncodingFormat']) ? $data['pinBlockEncodingFormat'] : null;
        $this->container['encryptedPin'] = isset($data['encryptedPin']) ? $data['encryptedPin'] : null;
        $this->container['encryptedKeySerialNumber'] = isset($data['encryptedKeySerialNumber']) ? $data['encryptedKeySerialNumber'] : null;
        $this->container['partnerSdkVersion'] = isset($data['partnerSdkVersion']) ? $data['partnerSdkVersion'] : null;
        $this->container['emvApplicationIdentifierAndDedicatedFileName'] = isset($data['emvApplicationIdentifierAndDedicatedFileName']) ? $data['emvApplicationIdentifierAndDedicatedFileName'] : null;
        $this->container['terminalCompliance'] = isset($data['terminalCompliance']) ? $data['terminalCompliance'] : null;
        $this->container['isDedicatedHardwareTerminal'] = isset($data['isDedicatedHardwareTerminal']) ? $data['isDedicatedHardwareTerminal'] : null;
        $this->container['terminalModel'] = isset($data['terminalModel']) ? $data['terminalModel'] : null;
        $this->container['terminalMake'] = isset($data['terminalMake']) ? $data['terminalMake'] : null;
        $this->container['serviceCode'] = isset($data['serviceCode']) ? $data['serviceCode'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets terminalId
     * @return string
     */
    public function getTerminalId()
    {
        return $this->container['terminalId'];
    }

    /**
     * Sets terminalId
     * @param string $terminalId Identifier for the terminal at your retail location. You can define this value yourself, but consult the processor for requirements.  #### CyberSource through VisaNet A list of all possible values is stored in your CyberSource account. If terminal ID validation is enabled for your CyberSource account, the value you send for this field is validated against the list each time you include the field in a request. To enable or disable terminal ID validation, contact CyberSource Customer Support.  When you do not include this field in a request, CyberSource uses the default value that is defined in your CyberSource account.  #### FDC Nashville Global To have your account configured to support this field, contact CyberSource Customer Support. This value must be a value that FDC Nashville Global issued to you.  #### For Payouts This field is applicable for CyberSource through VisaNet.  #### GPX Identifier for the terminal at your retail location. A list of all possible values is stored in your account. If terminal ID validation is enabled for your account, the value you send for this field is validated against the list each time you include the field in a request. To enable or disable terminal ID validation, contact customer support.  When you do not include this field in a request, the default value that is defined in your account is used.  Optional for authorizations.  #### Used by **Authorization** Optional for the following processors. When you do not include this field in a request, the default value that is defined in your account is used.   - American Express Direct   - Credit Mutuel-CIC   - FDC Nashville Global   - SIX - Chase Paymentech Solutions: Optional field. If you include this field in your request, you must also include `pointOfSaleInformation.catLevel`. - FDMS Nashville: The default value that is defined in your account is used. - GPX - OmniPay Direct: Optional field.  For the following processors, this field is not used. - GPN - JCN Gateway - RBS WorldPay Atlanta - TSYS Acquiring Solutions - Worldpay VAP  #### Card Present reply Terminal identifier assigned by the acquirer. This value must be printed on the receipt.
     * @return $this
     */
    public function setTerminalId($terminalId)
    {
        $this->container['terminalId'] = $terminalId;

        return $this;
    }

    /**
     * Gets terminalSerialNumber
     * @return string
     */
    public function getTerminalSerialNumber()
    {
        return $this->container['terminalSerialNumber'];
    }

    /**
     * Sets terminalSerialNumber
     * @param string $terminalSerialNumber Terminal serial number assigned by the hardware manufacturer. This value is provided by the client software that is installed on the POS terminal.  This value is not forwarded to the processor. Instead, the value is forwarded to the reporting functionality.  #### Used by **Authorization and Credit** Optional. This field is supported only by client software that is installed on your POS terminals for the following processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX
     * @return $this
     */
    public function setTerminalSerialNumber($terminalSerialNumber)
    {
        $this->container['terminalSerialNumber'] = $terminalSerialNumber;

        return $this;
    }

    /**
     * Gets cardholderVerificationMethodUsed
     * @return int
     */
    public function getCardholderVerificationMethodUsed()
    {
        return $this->container['cardholderVerificationMethodUsed'];
    }

    /**
     * Sets cardholderVerificationMethodUsed
     * @param int $cardholderVerificationMethodUsed Method that was used to verify the cardholder's identity. Possible values:    - `0`: No verification   - `1`: Signature   - `2`: PIN   - `3`: Cardholder device CVM   - `4`: Biometric   - `5`: OTP
     * @return $this
     */
    public function setCardholderVerificationMethodUsed($cardholderVerificationMethodUsed)
    {
        $this->container['cardholderVerificationMethodUsed'] = $cardholderVerificationMethodUsed;

        return $this;
    }

    /**
     * Gets laneNumber
     * @return string
     */
    public function getLaneNumber()
    {
        return $this->container['laneNumber'];
    }

    /**
     * Sets laneNumber
     * @param string $laneNumber Identifier for an alternate terminal at your retail location. You define the value for this field.  This field is supported only for MasterCard transactions on FDC Nashville Global. Otherwise, this field is not used by all other processors. Use the `terminalId` field to identify the main terminal at your retail location. If your retail location has multiple terminals, use this `laneNumber` field to identify the terminal used for the transaction.  This field is a pass-through, which means that the value is not checked or modified in any way before sending it to the processor.  Optional field.  #### Card present reply messaging Identifier for an alternate terminal at your retail location. You defined the value for this field in the request message. This value must be printed on the receipt.  This field is supported only for MasterCard transactions on FDC Nashville Global.
     * @return $this
     */
    public function setLaneNumber($laneNumber)
    {
        $this->container['laneNumber'] = $laneNumber;

        return $this;
    }

    /**
     * Gets catLevel
     * @return int
     */
    public function getCatLevel()
    {
        return $this->container['catLevel'];
    }

    /**
     * Sets catLevel
     * @param int $catLevel Type of cardholder-activated terminal. Possible values:   - 1: Automated dispensing machine  - 2: Self-service terminal  - 3: Limited amount terminal  - 4: In-flight commerce (IFC) terminal  - 5: Radio frequency device  - 6: Mobile acceptance terminal  - 7: Electronic cash register  - 8: E-commerce device at your location  - 9: Terminal or cash register that uses a dialup connection to connect to the transaction processing network  - 10: Card Activated Fuel Dispenser  - 11: Travel ticket vending machine #### Chase Paymentech Solutions Only values 1, 2, and 3 are supported.  Required if `pointOfSaleInformation.terminalID` is included in the request; otherwise, optional.  #### CyberSource through VisaNet Values 1 through 6 are supported on CyberSource through VisaNet, but some acquirers do not support all six values.  Optional field.  #### FDC Nashville Global Only values 7, 8, and 9 are supported.  Optional field for EMV transactions; otherwise, not used.  #### GPN Only values 6, 7, 8, and 9 are supported.  Required field.  #### JCN Gateway Only values 6, 7, 8, and 9 are supported.  Required field.  #### TSYS Acquiring Solutions Only value 6 is supported.  Required for transactions from mobile devices; otherwise, not used.  #### All other processors Not used.  Nonnegative integer.
     * @return $this
     */
    public function setCatLevel($catLevel)
    {
        $this->container['catLevel'] = $catLevel;

        return $this;
    }

    /**
     * Gets entryMode
     * @return string
     */
    public function getEntryMode()
    {
        return $this->container['entryMode'];
    }

    /**
     * Sets entryMode
     * @param string $entryMode Method of entering payment card information into the POS terminal. Possible values:   - `contact`: Read from direct contact with chip card.  - `contactless`: Read from a contactless interface using chip data.  - `keyed`: Manually keyed into POS terminal. This value is not supported on OmniPay Direct.  - `msd`: Read from a contactless interface using magnetic stripe data (MSD). This value is not supported on OmniPay Direct.  - `swiped`: Read from credit card magnetic stripe.  The `contact`, `contactless`, and `msd` values are supported only for EMV transactions.  #### Used by **Authorization** Required field.  #### Card Present Card present information about EMV applies only to credit card processing and PIN debit processing. All other card present information applies only to credit card processing.  #### PIN debit Required for a PIN debit purchase and a PIN debit credit request.
     * @return $this
     */
    public function setEntryMode($entryMode)
    {
        $this->container['entryMode'] = $entryMode;

        return $this;
    }

    /**
     * Gets terminalCapability
     * @return int
     */
    public function getTerminalCapability()
    {
        return $this->container['terminalCapability'];
    }

    /**
     * Sets terminalCapability
     * @param int $terminalCapability POS terminal's capability. Possible values:   - `1`: Terminal has a magnetic stripe reader only.  - `2`: Terminal has a magnetic stripe reader and manual entry capability.  - `3`: Terminal has manual entry capability only.  - `4`: Terminal can read chip cards.  - `5`: Terminal can read contactless chip cards; cannot use contact to read chip cards.  For an EMV transaction, the value of this field must be `4` or `5`.  #### PIN debit Required for PIN debit purchase and PIN debit credit request.  #### Used by **Authorization** Required for the following processors: - American Express Direct - Chase Paymentech Solutions - Credit Mutuel-CIC - FDC Nashville Global - FDMS Nashville - OmniPay Direct - SIX - Worldpay VAP  Optional for the following processors: - CyberSource through VisaNet - GPN - GPX - JCN Gateway - RBS WorldPay Atlanta - TSYS Acquiring Solutions
     * @return $this
     */
    public function setTerminalCapability($terminalCapability)
    {
        $this->container['terminalCapability'] = $terminalCapability;

        return $this;
    }

    /**
     * Gets operatingEnvironment
     * @return string
     */
    public function getOperatingEnvironment()
    {
        return $this->container['operatingEnvironment'];
    }

    /**
     * Sets operatingEnvironment
     * @param string $operatingEnvironment Operating environment.  Possible values for all card types except Mastercard: - `0`: No terminal used or unknown environment. - `1`: On merchant premises, attended. - `2`: On merchant premises, unattended. Examples: oil, kiosks, self-checkout, mobile telephone, personal digital assistant (PDA). - `3`: Off merchant premises, attended. Examples: portable POS devices at trade shows, at service calls, or in taxis. - `4`: Off merchant premises, unattended. Examples: vending machines, home computer, mobile telephone, PDA. - `5`: On premises of cardholder, unattended. - `9`: Unknown delivery mode. - `S`: Electronic delivery of product. Examples: music, software, or eTickets that are downloaded over the internet. - `T`: Physical delivery of product. Examples: music or software that is delivered by mail or by a courier.  #### Possible values for Mastercard: - `2`: On merchant premises, unattended, or cardholder terminal. Examples: oil, kiosks, self-checkout, home computer, mobile telephone, personal digital assistant (PDA). Cardholder terminal is supported only for Mastercard transactions on CyberSource through VisaNet. - `4`: Off merchant premises, unattended, or cardholder terminal. Examples: vending machines, home computer, mobile telephone, PDA. Cardholder terminal is supported only for Mastercard transactions on CyberSource through VisaNet.  This field is supported only for American Express Direct and CyberSource through VisaNet.
     * @return $this
     */
    public function setOperatingEnvironment($operatingEnvironment)
    {
        $this->container['operatingEnvironment'] = $operatingEnvironment;

        return $this;
    }

    /**
     * Gets emv
     * @return \CyberSource\Model\Ptsv2paymentsPointOfSaleInformationEmv
     */
    public function getEmv()
    {
        return $this->container['emv'];
    }

    /**
     * Sets emv
     * @param \CyberSource\Model\Ptsv2paymentsPointOfSaleInformationEmv $emv
     * @return $this
     */
    public function setEmv($emv)
    {
        $this->container['emv'] = $emv;

        return $this;
    }

    /**
     * Gets amexCapnData
     * @return string
     */
    public function getAmexCapnData()
    {
        return $this->container['amexCapnData'];
    }

    /**
     * Sets amexCapnData
     * @param string $amexCapnData Point-of-sale details for the transaction. This value is returned only for **American Express Direct**. CyberSource generates this value, which consists of a series of codes that identify terminal capability, security data, and specific conditions present at the time the transaction occurred. To comply with the CAPN requirements, this value must be included in all subsequent follow-on requests, such as captures and follow-on credits.  When you perform authorizations, captures, and credits through CyberSource, CyberSource passes this value from the authorization service to the subsequent services for you. However, when you perform authorizations through CyberSource and perform subsequent services through other financial institutions, you must ensure that your requests for captures and credits include this value.
     * @return $this
     */
    public function setAmexCapnData($amexCapnData)
    {
        $this->container['amexCapnData'] = $amexCapnData;

        return $this;
    }

    /**
     * Gets trackData
     * @return string
     */
    public function getTrackData()
    {
        return $this->container['trackData'];
    }

    /**
     * Sets trackData
     * @param string $trackData Card's track 1 and 2 data. For all processors except FDMS Nashville, this value consists of one of the following:   - Track 1 data  - Track 2 data  - Data for both tracks 1 and 2  For FDMS Nashville, this value consists of one of the following:  - Track 1 data  - Data for both tracks 1 and 2  Example: %B4111111111111111^SMITH/JOHN ^1612101976110000868000000?;4111111111111111=16121019761186800000?  #### Used by **Authorization** Required for Chase Paymentech Solutions, Credit Mutuel-CIC, CyberSource through VisaNet, FDC Nashville Global, JCN Gateway, OmniPay Direct, and SIX if `pointOfSaleInformation.entryMode` is equal to one of these values: - `contact` - `contactless` - `msd` - `swiped` Otherwise, this field not used.  Required for all other processors if `pointOfSaleInformation.entryMode=swiped`; otherwise, this field is not used.  #### GPX This field only supports transactions from the following card types: - Visa - Mastercard - AMEX - Discover - Diners - JCB - Union Pay International  #### PIN debit Track 2 data from the debit card. The sentinels are required. Required field for a PIN debit purchase and a PIN debit credit.
     * @return $this
     */
    public function setTrackData($trackData)
    {
        $this->container['trackData'] = $trackData;

        return $this;
    }

    /**
     * Gets storeAndForwardIndicator
     * @return string
     */
    public function getStoreAndForwardIndicator()
    {
        return $this->container['storeAndForwardIndicator'];
    }

    /**
     * Sets storeAndForwardIndicator
     * @param string $storeAndForwardIndicator When connectivity is unavailable, the client software that is installed on the POS terminal can store a transaction in its memory and send it for authorization when connectivity is restored. This value is provided by the client software that is installed on the POS terminal.  This value is not forwarded to the processor. Instead, the value is forwarded to the reporting functionality.  Possible values: - `Y`: Transaction was stored and then forwarded. - `N` (default): Transaction was not stored and then forwarded.  For authorizations and credits, this field is supported only on these processors: - American Express Direct - FDC Nashville Global - OmniPay Direct - SIX  Optional field.
     * @return $this
     */
    public function setStoreAndForwardIndicator($storeAndForwardIndicator)
    {
        $this->container['storeAndForwardIndicator'] = $storeAndForwardIndicator;

        return $this;
    }

    /**
     * Gets cardholderVerificationMethod
     * @return string[]
     */
    public function getCardholderVerificationMethod()
    {
        return $this->container['cardholderVerificationMethod'];
    }

    /**
     * Sets cardholderVerificationMethod
     * @param string[] $cardholderVerificationMethod Complete list of cardholder verification methods (CVMs) supported by the terminal. Optional field. Possible values: - `PIN`: For terminals with a PIN Pad - `Signature`: For terminals capable of receiving a signature - `pinOnGlass`: For terminals where PIN is entered on a glass-based capture mechanism  **EXAMPLE**: [\"PIN\",\"Signature\"]; [\"pinOnGlass\",\"Signature\"]
     * @return $this
     */
    public function setCardholderVerificationMethod($cardholderVerificationMethod)
    {
        $this->container['cardholderVerificationMethod'] = $cardholderVerificationMethod;

        return $this;
    }

    /**
     * Gets terminalCategory
     * @return string
     */
    public function getTerminalCategory()
    {
        return $this->container['terminalCategory'];
    }

    /**
     * Sets terminalCategory
     * @param string $terminalCategory Indicates the type of terminal.   Possible values: - `AFD`: Automated Fuel Dispenser
     * @return $this
     */
    public function setTerminalCategory($terminalCategory)
    {
        $this->container['terminalCategory'] = $terminalCategory;

        return $this;
    }

    /**
     * Gets terminalInputCapability
     * @return string[]
     */
    public function getTerminalInputCapability()
    {
        return $this->container['terminalInputCapability'];
    }

    /**
     * Sets terminalInputCapability
     * @param string[] $terminalInputCapability Complete list of card input methods supported by the terminal.  Possible values: - `Keyed`: Terminal can accept card data that is entered manually. - `Swiped`: Terminal can accept card data from a magnetic stripe reader. - `Contact`: Terminal can accept card data in EMV contact mode (\"dipping a card\"). - `Contactless`: Terminal can accept card data in EMV contactless mode (\"tapping a card\"). - `BarCode`: Terminal can read bar codes. - `QRcode`: Terminal can read or scan QR codes. - `OCR`: Terminal can perform optical character recognition (OCT) on the card.  **EXAMPLE**: [\"Keyed\",\"Swiped\",\"Contact\",\"Contactless\"]  #### Used by **Authorization and Credit** Optional. This field is supported only by client software that is installed on your POS terminals for the following processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX
     * @return $this
     */
    public function setTerminalInputCapability($terminalInputCapability)
    {
        $this->container['terminalInputCapability'] = $terminalInputCapability;

        return $this;
    }

    /**
     * Gets terminalCardCaptureCapability
     * @return string
     */
    public function getTerminalCardCaptureCapability()
    {
        return $this->container['terminalCardCaptureCapability'];
    }

    /**
     * Sets terminalCardCaptureCapability
     * @param string $terminalCardCaptureCapability Indicates whether the terminal can capture the card.  Possible values: - `1`: Terminal can capture card. - `0`: Terminal cannot capture card.  For authorizations and credits, this field is supported only by these processors: - American Express Direct - Credit Mutuel-CIC - OmniPay Direct  Optional field.
     * @return $this
     */
    public function setTerminalCardCaptureCapability($terminalCardCaptureCapability)
    {
        $this->container['terminalCardCaptureCapability'] = $terminalCardCaptureCapability;

        return $this;
    }

    /**
     * Gets terminalOutputCapability
     * @return string
     */
    public function getTerminalOutputCapability()
    {
        return $this->container['terminalOutputCapability'];
    }

    /**
     * Sets terminalOutputCapability
     * @param string $terminalOutputCapability Indicates whether the terminal can print or display messages.  Possible values: - 1: Neither - 2: Print only - 3: Display only - 4: Print and display - 5: Merchant terminal supports purchase only approvals  This field is supported for authorizations and credits only on the following processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX - VisaNet  Optional field.
     * @return $this
     */
    public function setTerminalOutputCapability($terminalOutputCapability)
    {
        $this->container['terminalOutputCapability'] = $terminalOutputCapability;

        return $this;
    }

    /**
     * Gets terminalPinCapability
     * @return int
     */
    public function getTerminalPinCapability()
    {
        return $this->container['terminalPinCapability'];
    }

    /**
     * Sets terminalPinCapability
     * @param int $terminalPinCapability Maximum PIN length that the terminal can capture.  Possible values: -  0: No PIN capture capability -  1: PIN capture capability unknown -  2: PIN Pad down -  4: Four characters -  5: Five characters -  6: Six characters -  7: Seven characters -  8: Eight characters -  9: Nine characters - 10: Ten characters - 11: Eleven characters - 12: Twelve characters  This field is supported for authorizations and credits only on the following processors: - American Express Direct - Credit Mutuel-CIC - OmniPay Direct - SIX - Visa Platform Connect  Required field for authorization or credit of PIN transactions.
     * @return $this
     */
    public function setTerminalPinCapability($terminalPinCapability)
    {
        $this->container['terminalPinCapability'] = $terminalPinCapability;

        return $this;
    }

    /**
     * Gets pinEntrySolution
     * @return string
     */
    public function getPinEntrySolution()
    {
        return $this->container['pinEntrySolution'];
    }

    /**
     * Sets pinEntrySolution
     * @param string $pinEntrySolution This field will contain the type of Pin Pad the terminal has.  Possible values: -   PCI-SPoC: Where the pin is being put on screen -   PCI-PTS: Where the pin is being put on actual hardware pin pad
     * @return $this
     */
    public function setPinEntrySolution($pinEntrySolution)
    {
        $this->container['pinEntrySolution'] = $pinEntrySolution;

        return $this;
    }

    /**
     * Gets deviceId
     * @return string
     */
    public function getDeviceId()
    {
        return $this->container['deviceId'];
    }

    /**
     * Sets deviceId
     * @param string $deviceId Value created by the client software that uniquely identifies the POS device. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX.
     * @return $this
     */
    public function setDeviceId($deviceId)
    {
        $this->container['deviceId'] = $deviceId;

        return $this;
    }

    /**
     * Gets pinBlockEncodingFormat
     * @return int
     */
    public function getPinBlockEncodingFormat()
    {
        return $this->container['pinBlockEncodingFormat'];
    }

    /**
     * Sets pinBlockEncodingFormat
     * @param int $pinBlockEncodingFormat Format that is used to encode the PIN block. This value is provided by the client software that is installed on the POS terminal.  Possible values: - `0`: ISO 9564 format 0 - `1`: ISO 9564 format 1 - `2`: ISO 9564 format 2 - `3`: ISO 9564 format 3  #### Used by **Authorization, PIN Debit** - Required when the cardholder enters a PIN and the card cannot verify the PIN, which means that the issuer must verify the PIN. - Required for PIN debit credit or PIN debit purchase.  For authorizations, this field is supported only on these processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX  This field is also supported by processors that support chip and online PIN transactions. The following table lists the EMV Cards and Cardholder Verification Methods (CVMs) that these processors support:  | Processor | Chip and Offline PIN | Chip and Online PIN | Chip and Signature | | --- | --- | --- | --- | | American Express Direct | Yes | Yes | Yes | | Chase Paymentech Solutions | No | No | Yes | | Credit Mutuel-CIC | Yes | Yes | Yes | | CyberSource through VisaNet | Yes | No | Yes | | FDC Nashville Global | Yes | Yes | Yes | | GPN | No | No | Yes | | OmniPay Direct | Yes | No | Yes | | SIX | Yes | Yes | Yes |  #### GPX For chip and online PIN transactions for authorization, GPX supports the following EMV Cards and Cardholder Verification Methods (CVMs): - Chip and Offline PIN - Chip and Signature  For PIN Debit Purchase and Credit Service transactions, GPX supports the following EMV Cards and Cardholder Verification Methods (CVMs): - Chip and Online PIN
     * @return $this
     */
    public function setPinBlockEncodingFormat($pinBlockEncodingFormat)
    {
        $this->container['pinBlockEncodingFormat'] = $pinBlockEncodingFormat;

        return $this;
    }

    /**
     * Gets encryptedPin
     * @return string
     */
    public function getEncryptedPin()
    {
        return $this->container['encryptedPin'];
    }

    /**
     * Sets encryptedPin
     * @param string $encryptedPin Encrypted PIN.  This value is provided by the client software that is installed on the POS terminal.  #### Used by **Authorization, PIN Debit** Required when the cardholder enters a PIN and the card cannot verify the PIN, which means that the issuer must verify the PIN. Required for PIN debit credit or PIN debit purchase. Required for online PIN transactions.  For authorizations, this field is supported only on these processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX  This field is also used by processors that support chip and online PIN transactions. The following table lists the EMV Cards and Cardholder Verification Methods (CVMs) that these processors support:  | Processor | Chip and Offline PIN | Chip and Online PIN | Chip and Signature | | --- | --- | --- | --- | | American Express Direct | Yes | Yes | Yes | | Chase Paymentech Solutions | No | No | Yes | | Credit Mutuel-CIC | Yes | Yes | Yes | | CyberSource through VisaNet | Yes | No | Yes | | FDC Nashville Global | Yes | Yes | Yes | | GPN | No | No | Yes | | OmniPay Direct | Yes | No | Yes | | SIX | Yes | Yes | Yes |
     * @return $this
     */
    public function setEncryptedPin($encryptedPin)
    {
        $this->container['encryptedPin'] = $encryptedPin;

        return $this;
    }

    /**
     * Gets encryptedKeySerialNumber
     * @return string
     */
    public function getEncryptedKeySerialNumber()
    {
        return $this->container['encryptedKeySerialNumber'];
    }

    /**
     * Sets encryptedKeySerialNumber
     * @param string $encryptedKeySerialNumber Combination of the device's unique identifier and a transaction counter that is used in the process of decrypting the encrypted PIN. The entity that injected the PIN encryption keys into the terminal decrypts the encrypted PIN and creates this value.  For all terminals that are using derived unique key per transaction (DUKPT) encryption, this is generated as a single number within the terminal.  #### Used by **Authorization, PIN Debit** - Required when the cardholder enters a PIN and the card cannot verify the PIN, which means that the issuer must verify the PIN. - Required for PIN debit credit or PIN debit purchase. - Required for online PIN transactions  For authorizations, this field is supported only on these processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX  This field is also used by processors that support chip and online PIN transactions. The following table lists the EMV Cards and Cardholder Verification Methods (CVMs) that these processors support:  | Processor | Chip and Offline PIN | Chip and Online PIN | Chip and Signature | | --- | --- | --- | --- | | American Express Direct | Yes | Yes | Yes | | Chase Paymentech Solutions | No | No | Yes | | Credit Mutuel-CIC | Yes | Yes | Yes | | CyberSource through VisaNet | Yes | No | Yes | | FDC Nashville Global | Yes | Yes | Yes | | GPN | No | No | Yes | | OmniPay Direct | Yes | No | Yes | | SIX | Yes | Yes | Yes |
     * @return $this
     */
    public function setEncryptedKeySerialNumber($encryptedKeySerialNumber)
    {
        $this->container['encryptedKeySerialNumber'] = $encryptedKeySerialNumber;

        return $this;
    }

    /**
     * Gets partnerSdkVersion
     * @return string
     */
    public function getPartnerSdkVersion()
    {
        return $this->container['partnerSdkVersion'];
    }

    /**
     * Sets partnerSdkVersion
     * @param string $partnerSdkVersion Version of the software installed on the POS terminal. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX.  For authorizations and credits, this field is supported only on these processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX
     * @return $this
     */
    public function setPartnerSdkVersion($partnerSdkVersion)
    {
        $this->container['partnerSdkVersion'] = $partnerSdkVersion;

        return $this;
    }

    /**
     * Gets emvApplicationIdentifierAndDedicatedFileName
     * @return string
     */
    public function getEmvApplicationIdentifierAndDedicatedFileName()
    {
        return $this->container['emvApplicationIdentifierAndDedicatedFileName'];
    }

    /**
     * Sets emvApplicationIdentifierAndDedicatedFileName
     * @param string $emvApplicationIdentifierAndDedicatedFileName This 32 byte length-maximum EBCDIC-K value is used to identify which chip application was performed between the terminal and the chip product. The included values are the Application Identifier (AID) and the Dedicated File (DF) name. It is available to early- or full-option VSDC issuers. Only single byte Katakana characters that can map to the EBCDIC-K table expected in the name.
     * @return $this
     */
    public function setEmvApplicationIdentifierAndDedicatedFileName($emvApplicationIdentifierAndDedicatedFileName)
    {
        $this->container['emvApplicationIdentifierAndDedicatedFileName'] = $emvApplicationIdentifierAndDedicatedFileName;

        return $this;
    }

    /**
     * Gets terminalCompliance
     * @return string
     */
    public function getTerminalCompliance()
    {
        return $this->container['terminalCompliance'];
    }

    /**
     * Sets terminalCompliance
     * @param string $terminalCompliance Flag that indicates whether the terminal is compliant with standards mandated by the Reserve Bank of India for card-present domestic transactions in India.  Format: - First character indicates whether the terminal supports terminal line encryption (TLE). Possible values:   - 1: Not certified   - 2: Certified - Second character indicates whether the terminal supports Unique Key Per Transaction (UKPT) and Derived Unique Key Per Transaction (DUKPT). Possible values:   - 1: Not certified   - 2: Certified  **Example** `21` indicates that the terminal supports TLE but does not support UKPT/DUKPT.  You and the terminal vendors are responsible for terminal certification. If you have questions, contact your acquirer.  This field is supported only for Mastercard transactions on CyberSource through VisaNet.  **Note** On CyberSource through VisaNet, the value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR6 - Position: 92-93 - Field: Mastercard Terminal Compliance Indicator  The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant's acquirer, who uses this information to facilitate end-of-day clearing processing with payment networks.  #### Used by **Authorization** Required for card-present transactions in India. Otherwise, not used.
     * @return $this
     */
    public function setTerminalCompliance($terminalCompliance)
    {
        $this->container['terminalCompliance'] = $terminalCompliance;

        return $this;
    }

    /**
     * Gets isDedicatedHardwareTerminal
     * @return string
     */
    public function getIsDedicatedHardwareTerminal()
    {
        return $this->container['isDedicatedHardwareTerminal'];
    }

    /**
     * Sets isDedicatedHardwareTerminal
     * @param string $isDedicatedHardwareTerminal Type of mPOS device. Possible values: - 0: Dongle - 1: Phone or tablet  This optional field is supported only for Mastercard transactions on CyberSource through VisaNet.  The value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR6 - Position: 141 - Field: Mastercard mPOS Transaction  The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant's acquirer, who uses this information to facilitate end-of-day clearing processing with payment networks.
     * @return $this
     */
    public function setIsDedicatedHardwareTerminal($isDedicatedHardwareTerminal)
    {
        $this->container['isDedicatedHardwareTerminal'] = $isDedicatedHardwareTerminal;

        return $this;
    }

    /**
     * Gets terminalModel
     * @return string
     */
    public function getTerminalModel()
    {
        return $this->container['terminalModel'];
    }

    /**
     * Sets terminalModel
     * @param string $terminalModel This is the model name of the reader which is used to accept the payment. Possible values:  - E3555  - P400  - A920
     * @return $this
     */
    public function setTerminalModel($terminalModel)
    {
        $this->container['terminalModel'] = $terminalModel;

        return $this;
    }

    /**
     * Gets terminalMake
     * @return string
     */
    public function getTerminalMake()
    {
        return $this->container['terminalMake'];
    }

    /**
     * Sets terminalMake
     * @param string $terminalMake This is the manufacturer name of the reader which is used to accept the payment. Possible values:  - PAX  - Verifone  - Ingenico
     * @return $this
     */
    public function setTerminalMake($terminalMake)
    {
        $this->container['terminalMake'] = $terminalMake;

        return $this;
    }

    /**
     * Gets serviceCode
     * @return string
     */
    public function getServiceCode()
    {
        return $this->container['serviceCode'];
    }

    /**
     * Sets serviceCode
     * @param string $serviceCode #### Visa Platform Connect Mastercard service code that is included in the track data.  This field is supported only for Mastercard on Visa Platform Connect.   You can extract the service code from the track data and provide it in this API field.   When not provided it will be extracted from:   - Track2Data for MSR transactions   - EMV tag 5F30 for EMV transactions  To enable this feature please call support.
     * @return $this
     */
    public function setServiceCode($serviceCode)
    {
        $this->container['serviceCode'] = $serviceCode;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


