<?php
/**
 * Riskv1authenticationsOrderInformationLineItems
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * Riskv1authenticationsOrderInformationLineItems Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Riskv1authenticationsOrderInformationLineItems implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'riskv1authentications_orderInformation_lineItems';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'totalAmount' => 'string',
        'unitPrice' => 'string',
        'quantity' => 'int',
        'giftCardCurrency' => 'int',
        'productSKU' => 'string',
        'productDescription' => 'string',
        'productName' => 'string',
        'passenger' => '\CyberSource\Model\Ptsv2paymentsOrderInformationPassenger',
        'shippingDestinationTypes' => 'string',
        'taxAmount' => 'string',
        'shippingAddress1' => 'string',
        'shippingAddress2' => 'string',
        'shippingCity' => 'string',
        'shippingCountryCode' => 'string',
        'shippingFirstName' => 'string',
        'shippingLastName' => 'string',
        'shippingMiddleName' => 'string',
        'shippingPhone' => 'int',
        'shippingPostalCode' => 'int',
        'shippingState' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'totalAmount' => null,
        'unitPrice' => null,
        'quantity' => null,
        'giftCardCurrency' => null,
        'productSKU' => null,
        'productDescription' => null,
        'productName' => null,
        'passenger' => null,
        'shippingDestinationTypes' => null,
        'taxAmount' => null,
        'shippingAddress1' => null,
        'shippingAddress2' => null,
        'shippingCity' => null,
        'shippingCountryCode' => null,
        'shippingFirstName' => null,
        'shippingLastName' => null,
        'shippingMiddleName' => null,
        'shippingPhone' => null,
        'shippingPostalCode' => null,
        'shippingState' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'totalAmount' => 'totalAmount',
        'unitPrice' => 'unitPrice',
        'quantity' => 'quantity',
        'giftCardCurrency' => 'giftCardCurrency',
        'productSKU' => 'productSKU',
        'productDescription' => 'productDescription',
        'productName' => 'productName',
        'passenger' => 'passenger',
        'shippingDestinationTypes' => 'shippingDestinationTypes',
        'taxAmount' => 'taxAmount',
        'shippingAddress1' => 'shippingAddress1',
        'shippingAddress2' => 'shippingAddress2',
        'shippingCity' => 'shippingCity',
        'shippingCountryCode' => 'shippingCountryCode',
        'shippingFirstName' => 'shippingFirstName',
        'shippingLastName' => 'shippingLastName',
        'shippingMiddleName' => 'shippingMiddleName',
        'shippingPhone' => 'shippingPhone',
        'shippingPostalCode' => 'shippingPostalCode',
        'shippingState' => 'shippingState'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'totalAmount' => 'setTotalAmount',
        'unitPrice' => 'setUnitPrice',
        'quantity' => 'setQuantity',
        'giftCardCurrency' => 'setGiftCardCurrency',
        'productSKU' => 'setProductSKU',
        'productDescription' => 'setProductDescription',
        'productName' => 'setProductName',
        'passenger' => 'setPassenger',
        'shippingDestinationTypes' => 'setShippingDestinationTypes',
        'taxAmount' => 'setTaxAmount',
        'shippingAddress1' => 'setShippingAddress1',
        'shippingAddress2' => 'setShippingAddress2',
        'shippingCity' => 'setShippingCity',
        'shippingCountryCode' => 'setShippingCountryCode',
        'shippingFirstName' => 'setShippingFirstName',
        'shippingLastName' => 'setShippingLastName',
        'shippingMiddleName' => 'setShippingMiddleName',
        'shippingPhone' => 'setShippingPhone',
        'shippingPostalCode' => 'setShippingPostalCode',
        'shippingState' => 'setShippingState'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'totalAmount' => 'getTotalAmount',
        'unitPrice' => 'getUnitPrice',
        'quantity' => 'getQuantity',
        'giftCardCurrency' => 'getGiftCardCurrency',
        'productSKU' => 'getProductSKU',
        'productDescription' => 'getProductDescription',
        'productName' => 'getProductName',
        'passenger' => 'getPassenger',
        'shippingDestinationTypes' => 'getShippingDestinationTypes',
        'taxAmount' => 'getTaxAmount',
        'shippingAddress1' => 'getShippingAddress1',
        'shippingAddress2' => 'getShippingAddress2',
        'shippingCity' => 'getShippingCity',
        'shippingCountryCode' => 'getShippingCountryCode',
        'shippingFirstName' => 'getShippingFirstName',
        'shippingLastName' => 'getShippingLastName',
        'shippingMiddleName' => 'getShippingMiddleName',
        'shippingPhone' => 'getShippingPhone',
        'shippingPostalCode' => 'getShippingPostalCode',
        'shippingState' => 'getShippingState'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['totalAmount'] = isset($data['totalAmount']) ? $data['totalAmount'] : null;
        $this->container['unitPrice'] = isset($data['unitPrice']) ? $data['unitPrice'] : null;
        $this->container['quantity'] = isset($data['quantity']) ? $data['quantity'] : null;
        $this->container['giftCardCurrency'] = isset($data['giftCardCurrency']) ? $data['giftCardCurrency'] : null;
        $this->container['productSKU'] = isset($data['productSKU']) ? $data['productSKU'] : null;
        $this->container['productDescription'] = isset($data['productDescription']) ? $data['productDescription'] : null;
        $this->container['productName'] = isset($data['productName']) ? $data['productName'] : null;
        $this->container['passenger'] = isset($data['passenger']) ? $data['passenger'] : null;
        $this->container['shippingDestinationTypes'] = isset($data['shippingDestinationTypes']) ? $data['shippingDestinationTypes'] : null;
        $this->container['taxAmount'] = isset($data['taxAmount']) ? $data['taxAmount'] : null;
        $this->container['shippingAddress1'] = isset($data['shippingAddress1']) ? $data['shippingAddress1'] : null;
        $this->container['shippingAddress2'] = isset($data['shippingAddress2']) ? $data['shippingAddress2'] : null;
        $this->container['shippingCity'] = isset($data['shippingCity']) ? $data['shippingCity'] : null;
        $this->container['shippingCountryCode'] = isset($data['shippingCountryCode']) ? $data['shippingCountryCode'] : null;
        $this->container['shippingFirstName'] = isset($data['shippingFirstName']) ? $data['shippingFirstName'] : null;
        $this->container['shippingLastName'] = isset($data['shippingLastName']) ? $data['shippingLastName'] : null;
        $this->container['shippingMiddleName'] = isset($data['shippingMiddleName']) ? $data['shippingMiddleName'] : null;
        $this->container['shippingPhone'] = isset($data['shippingPhone']) ? $data['shippingPhone'] : null;
        $this->container['shippingPostalCode'] = isset($data['shippingPostalCode']) ? $data['shippingPostalCode'] : null;
        $this->container['shippingState'] = isset($data['shippingState']) ? $data['shippingState'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        if ($this->container['unitPrice'] === null) {
            $invalid_properties[] = "'unitPrice' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        if ($this->container['unitPrice'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets totalAmount
     * @return string
     */
    public function getTotalAmount()
    {
        return $this->container['totalAmount'];
    }

    /**
     * Sets totalAmount
     * @param string $totalAmount Total amount for the item. Normally calculated as the unit price times quantity.  When `orderInformation.lineItems[].productCode` is \"gift_card\", this is the purchase amount total for prepaid gift cards in major units.  Example: 123.45 USD = 123
     * @return $this
     */
    public function setTotalAmount($totalAmount)
    {
        $this->container['totalAmount'] = $totalAmount;

        return $this;
    }

    /**
     * Gets unitPrice
     * @return string
     */
    public function getUnitPrice()
    {
        return $this->container['unitPrice'];
    }

    /**
     * Sets unitPrice
     * @param string $unitPrice Per-item price of the product. This value for this field cannot be negative.  You must include either this field or the request-level field `orderInformation.amountDetails.totalAmount` in your request.  You can include a decimal point (.), but you cannot include any other special characters. The value is truncated to the correct number of decimal places.  #### DCC with a Third-Party Provider Set this field to the converted amount that was returned by the DCC provider. You must include either the 1st line item in the order and this field, or the request-level field `orderInformation.amountDetails.totalAmount` in your request.  #### Tax Calculation Required field for U.S., Canadian, international and value added taxes.  #### Zero Amount Authorizations If your processor supports zero amount authorizations, you can set this field to 0 for the authorization to check if the card is lost or stolen.  #### Maximum Field Lengths For GPN and JCN Gateway: Decimal (10) All other processors: Decimal (15)
     * @return $this
     */
    public function setUnitPrice($unitPrice)
    {
        $this->container['unitPrice'] = $unitPrice;

        return $this;
    }

    /**
     * Gets quantity
     * @return int
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     * @param int $quantity Number of units for this order. Must be a non-negative integer.  The default is `1`. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the other values related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes.
     * @return $this
     */
    public function setQuantity($quantity)
    {
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets giftCardCurrency
     * @return int
     */
    public function getGiftCardCurrency()
    {
        return $this->container['giftCardCurrency'];
    }

    /**
     * Sets giftCardCurrency
     * @param int $giftCardCurrency When `orderInformation.lineItems[].productCode` is \"gift_card\", this is the currency used for the gift card purchase.  For the possible values, see the [ISO Standard Currency Codes.](http://apps.cybersource.com/library/documentation/sbc/quickref/currencies.pdf)
     * @return $this
     */
    public function setGiftCardCurrency($giftCardCurrency)
    {
        $this->container['giftCardCurrency'] = $giftCardCurrency;

        return $this;
    }

    /**
     * Gets productSKU
     * @return string
     */
    public function getProductSKU()
    {
        return $this->container['productSKU'];
    }

    /**
     * Sets productSKU
     * @param string $productSKU Product identifier code. Also known as the Stock Keeping Unit (SKU) code for the product.  For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not set to **default** or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S. and Canadian taxes. Not applicable to international and value added taxes. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the values related to shipping and/or handling.
     * @return $this
     */
    public function setProductSKU($productSKU)
    {
        $this->container['productSKU'] = $productSKU;

        return $this;
    }

    /**
     * Gets productDescription
     * @return string
     */
    public function getProductDescription()
    {
        return $this->container['productDescription'];
    }

    /**
     * Sets productDescription
     * @param string $productDescription Brief description of item.
     * @return $this
     */
    public function setProductDescription($productDescription)
    {
        $this->container['productDescription'] = $productDescription;

        return $this;
    }

    /**
     * Gets productName
     * @return string
     */
    public function getProductName()
    {
        return $this->container['productName'];
    }

    /**
     * Sets productName
     * @param string $productName For an authorization or capture transaction (`processingOptions.capture` is `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes.
     * @return $this
     */
    public function setProductName($productName)
    {
        $this->container['productName'] = $productName;

        return $this;
    }

    /**
     * Gets passenger
     * @return \CyberSource\Model\Ptsv2paymentsOrderInformationPassenger
     */
    public function getPassenger()
    {
        return $this->container['passenger'];
    }

    /**
     * Sets passenger
     * @param \CyberSource\Model\Ptsv2paymentsOrderInformationPassenger $passenger
     * @return $this
     */
    public function setPassenger($passenger)
    {
        $this->container['passenger'] = $passenger;

        return $this;
    }

    /**
     * Gets shippingDestinationTypes
     * @return string
     */
    public function getShippingDestinationTypes()
    {
        return $this->container['shippingDestinationTypes'];
    }

    /**
     * Sets shippingDestinationTypes
     * @param string $shippingDestinationTypes Destination to where the item will be shipped. Example: Commercial, Residential, Store
     * @return $this
     */
    public function setShippingDestinationTypes($shippingDestinationTypes)
    {
        $this->container['shippingDestinationTypes'] = $shippingDestinationTypes;

        return $this;
    }

    /**
     * Gets taxAmount
     * @return string
     */
    public function getTaxAmount()
    {
        return $this->container['taxAmount'];
    }

    /**
     * Sets taxAmount
     * @param string $taxAmount Total tax to apply to the product. This value cannot be negative. The tax amount and the offer amount must be in the same currency. The tax amount field is additive.  The following example uses a two-exponent currency such as USD:   1. You include each line item in your request.  ..- 1st line item has amount=10.00, quantity=1, and taxAmount=0.80  ..- 2nd line item has amount=20.00, quantity=1, and taxAmount=1.60  2. The total amount authorized will be 32.40, not 30.00 with 2.40 of tax included.  Optional field.  #### Airlines processing Tax portion of the order amount. This value cannot exceed 99999999999999 (fourteen 9s). Format: English characters only. Optional request field for a line item.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes.  Note if you send this field in your tax request, the value in the field will override the tax engine
     * @return $this
     */
    public function setTaxAmount($taxAmount)
    {
        $this->container['taxAmount'] = $taxAmount;

        return $this;
    }

    /**
     * Gets shippingAddress1
     * @return string
     */
    public function getShippingAddress1()
    {
        return $this->container['shippingAddress1'];
    }

    /**
     * Sets shippingAddress1
     * @param string $shippingAddress1 Address where item will be shipped
     * @return $this
     */
    public function setShippingAddress1($shippingAddress1)
    {
        $this->container['shippingAddress1'] = $shippingAddress1;

        return $this;
    }

    /**
     * Gets shippingAddress2
     * @return string
     */
    public function getShippingAddress2()
    {
        return $this->container['shippingAddress2'];
    }

    /**
     * Sets shippingAddress2
     * @param string $shippingAddress2 Address where item will be shipped
     * @return $this
     */
    public function setShippingAddress2($shippingAddress2)
    {
        $this->container['shippingAddress2'] = $shippingAddress2;

        return $this;
    }

    /**
     * Gets shippingCity
     * @return string
     */
    public function getShippingCity()
    {
        return $this->container['shippingCity'];
    }

    /**
     * Sets shippingCity
     * @param string $shippingCity City where item will be shipped
     * @return $this
     */
    public function setShippingCity($shippingCity)
    {
        $this->container['shippingCity'] = $shippingCity;

        return $this;
    }

    /**
     * Gets shippingCountryCode
     * @return string
     */
    public function getShippingCountryCode()
    {
        return $this->container['shippingCountryCode'];
    }

    /**
     * Sets shippingCountryCode
     * @param string $shippingCountryCode Country where item will be shipped
     * @return $this
     */
    public function setShippingCountryCode($shippingCountryCode)
    {
        $this->container['shippingCountryCode'] = $shippingCountryCode;

        return $this;
    }

    /**
     * Gets shippingFirstName
     * @return string
     */
    public function getShippingFirstName()
    {
        return $this->container['shippingFirstName'];
    }

    /**
     * Sets shippingFirstName
     * @param string $shippingFirstName Customer's first name
     * @return $this
     */
    public function setShippingFirstName($shippingFirstName)
    {
        $this->container['shippingFirstName'] = $shippingFirstName;

        return $this;
    }

    /**
     * Gets shippingLastName
     * @return string
     */
    public function getShippingLastName()
    {
        return $this->container['shippingLastName'];
    }

    /**
     * Sets shippingLastName
     * @param string $shippingLastName Customer's last name
     * @return $this
     */
    public function setShippingLastName($shippingLastName)
    {
        $this->container['shippingLastName'] = $shippingLastName;

        return $this;
    }

    /**
     * Gets shippingMiddleName
     * @return string
     */
    public function getShippingMiddleName()
    {
        return $this->container['shippingMiddleName'];
    }

    /**
     * Sets shippingMiddleName
     * @param string $shippingMiddleName Customer's middle name
     * @return $this
     */
    public function setShippingMiddleName($shippingMiddleName)
    {
        $this->container['shippingMiddleName'] = $shippingMiddleName;

        return $this;
    }

    /**
     * Gets shippingPhone
     * @return int
     */
    public function getShippingPhone()
    {
        return $this->container['shippingPhone'];
    }

    /**
     * Sets shippingPhone
     * @param int $shippingPhone Phone number where item will be shipped
     * @return $this
     */
    public function setShippingPhone($shippingPhone)
    {
        $this->container['shippingPhone'] = $shippingPhone;

        return $this;
    }

    /**
     * Gets shippingPostalCode
     * @return int
     */
    public function getShippingPostalCode()
    {
        return $this->container['shippingPostalCode'];
    }

    /**
     * Sets shippingPostalCode
     * @param int $shippingPostalCode Postal code where item will be shipped
     * @return $this
     */
    public function setShippingPostalCode($shippingPostalCode)
    {
        $this->container['shippingPostalCode'] = $shippingPostalCode;

        return $this;
    }

    /**
     * Gets shippingState
     * @return string
     */
    public function getShippingState()
    {
        return $this->container['shippingState'];
    }

    /**
     * Sets shippingState
     * @param string $shippingState State where item will be shipped
     * @return $this
     */
    public function setShippingState($shippingState)
    {
        $this->container['shippingState'] = $shippingState;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


