<?php
/**
 * SAConfig
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * SAConfig Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SAConfig implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'SAConfig';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'parentProfileId' => 'string',
        'contactInformation' => '\CyberSource\Model\SAConfigContactInformation',
        'notifications' => '\CyberSource\Model\SAConfigNotifications',
        'service' => '\CyberSource\Model\SAConfigService',
        'paymentMethods' => '\CyberSource\Model\SAConfigPaymentMethods',
        'checkout' => '\CyberSource\Model\SAConfigCheckout',
        'paymentTypes' => '\CyberSource\Model\SAConfigPaymentTypes'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'parentProfileId' => null,
        'contactInformation' => null,
        'notifications' => null,
        'service' => null,
        'paymentMethods' => null,
        'checkout' => null,
        'paymentTypes' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'parentProfileId' => 'parentProfileId',
        'contactInformation' => 'contactInformation',
        'notifications' => 'notifications',
        'service' => 'service',
        'paymentMethods' => 'paymentMethods',
        'checkout' => 'checkout',
        'paymentTypes' => 'paymentTypes'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'parentProfileId' => 'setParentProfileId',
        'contactInformation' => 'setContactInformation',
        'notifications' => 'setNotifications',
        'service' => 'setService',
        'paymentMethods' => 'setPaymentMethods',
        'checkout' => 'setCheckout',
        'paymentTypes' => 'setPaymentTypes'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'parentProfileId' => 'getParentProfileId',
        'contactInformation' => 'getContactInformation',
        'notifications' => 'getNotifications',
        'service' => 'getService',
        'paymentMethods' => 'getPaymentMethods',
        'checkout' => 'getCheckout',
        'paymentTypes' => 'getPaymentTypes'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['parentProfileId'] = isset($data['parentProfileId']) ? $data['parentProfileId'] : null;
        $this->container['contactInformation'] = isset($data['contactInformation']) ? $data['contactInformation'] : null;
        $this->container['notifications'] = isset($data['notifications']) ? $data['notifications'] : null;
        $this->container['service'] = isset($data['service']) ? $data['service'] : null;
        $this->container['paymentMethods'] = isset($data['paymentMethods']) ? $data['paymentMethods'] : null;
        $this->container['checkout'] = isset($data['checkout']) ? $data['checkout'] : null;
        $this->container['paymentTypes'] = isset($data['paymentTypes']) ? $data['paymentTypes'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets parentProfileId
     * @return string
     */
    public function getParentProfileId()
    {
        return $this->container['parentProfileId'];
    }

    /**
     * Sets parentProfileId
     * @param string $parentProfileId You can group Secure Acceptance profiles under parent profiles. By changing the parent profile, you can update all profiles underneath that parent. Specify the Parent Profile ID here.
     * @return $this
     */
    public function setParentProfileId($parentProfileId)
    {
        $this->container['parentProfileId'] = $parentProfileId;

        return $this;
    }

    /**
     * Gets contactInformation
     * @return \CyberSource\Model\SAConfigContactInformation
     */
    public function getContactInformation()
    {
        return $this->container['contactInformation'];
    }

    /**
     * Sets contactInformation
     * @param \CyberSource\Model\SAConfigContactInformation $contactInformation
     * @return $this
     */
    public function setContactInformation($contactInformation)
    {
        $this->container['contactInformation'] = $contactInformation;

        return $this;
    }

    /**
     * Gets notifications
     * @return \CyberSource\Model\SAConfigNotifications
     */
    public function getNotifications()
    {
        return $this->container['notifications'];
    }

    /**
     * Sets notifications
     * @param \CyberSource\Model\SAConfigNotifications $notifications
     * @return $this
     */
    public function setNotifications($notifications)
    {
        $this->container['notifications'] = $notifications;

        return $this;
    }

    /**
     * Gets service
     * @return \CyberSource\Model\SAConfigService
     */
    public function getService()
    {
        return $this->container['service'];
    }

    /**
     * Sets service
     * @param \CyberSource\Model\SAConfigService $service
     * @return $this
     */
    public function setService($service)
    {
        $this->container['service'] = $service;

        return $this;
    }

    /**
     * Gets paymentMethods
     * @return \CyberSource\Model\SAConfigPaymentMethods
     */
    public function getPaymentMethods()
    {
        return $this->container['paymentMethods'];
    }

    /**
     * Sets paymentMethods
     * @param \CyberSource\Model\SAConfigPaymentMethods $paymentMethods
     * @return $this
     */
    public function setPaymentMethods($paymentMethods)
    {
        $this->container['paymentMethods'] = $paymentMethods;

        return $this;
    }

    /**
     * Gets checkout
     * @return \CyberSource\Model\SAConfigCheckout
     */
    public function getCheckout()
    {
        return $this->container['checkout'];
    }

    /**
     * Sets checkout
     * @param \CyberSource\Model\SAConfigCheckout $checkout
     * @return $this
     */
    public function setCheckout($checkout)
    {
        $this->container['checkout'] = $checkout;

        return $this;
    }

    /**
     * Gets paymentTypes
     * @return \CyberSource\Model\SAConfigPaymentTypes
     */
    public function getPaymentTypes()
    {
        return $this->container['paymentTypes'];
    }

    /**
     * Sets paymentTypes
     * @param \CyberSource\Model\SAConfigPaymentTypes $paymentTypes
     * @return $this
     */
    public function setPaymentTypes($paymentTypes)
    {
        $this->container['paymentTypes'] = $paymentTypes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


