<?php
/**
 * TmsCardArt
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * TmsCardArt Class Doc Comment
 *
 * @category    Class
 * @description Card art associated with the tokenized card.
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class TmsCardArt implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'TmsCardArt';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'foregroundColor' => 'string',
        'combinedAsset' => '\CyberSource\Model\TmsCardArtCombinedAsset',
        'brandLogoAsset' => '\CyberSource\Model\TmsCardArtBrandLogoAsset',
        'issuerLogoAsset' => '\CyberSource\Model\TmsCardArtIssuerLogoAsset',
        'iconAsset' => '\CyberSource\Model\TmsCardArtIconAsset'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'foregroundColor' => null,
        'combinedAsset' => null,
        'brandLogoAsset' => null,
        'issuerLogoAsset' => null,
        'iconAsset' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'foregroundColor' => 'foregroundColor',
        'combinedAsset' => 'combinedAsset',
        'brandLogoAsset' => 'brandLogoAsset',
        'issuerLogoAsset' => 'issuerLogoAsset',
        'iconAsset' => 'iconAsset'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'foregroundColor' => 'setForegroundColor',
        'combinedAsset' => 'setCombinedAsset',
        'brandLogoAsset' => 'setBrandLogoAsset',
        'issuerLogoAsset' => 'setIssuerLogoAsset',
        'iconAsset' => 'setIconAsset'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'foregroundColor' => 'getForegroundColor',
        'combinedAsset' => 'getCombinedAsset',
        'brandLogoAsset' => 'getBrandLogoAsset',
        'issuerLogoAsset' => 'getIssuerLogoAsset',
        'iconAsset' => 'getIconAsset'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['foregroundColor'] = isset($data['foregroundColor']) ? $data['foregroundColor'] : null;
        $this->container['combinedAsset'] = isset($data['combinedAsset']) ? $data['combinedAsset'] : null;
        $this->container['brandLogoAsset'] = isset($data['brandLogoAsset']) ? $data['brandLogoAsset'] : null;
        $this->container['issuerLogoAsset'] = isset($data['issuerLogoAsset']) ? $data['issuerLogoAsset'] : null;
        $this->container['iconAsset'] = isset($data['iconAsset']) ? $data['iconAsset'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets foregroundColor
     * @return string
     */
    public function getForegroundColor()
    {
        return $this->container['foregroundColor'];
    }

    /**
     * Sets foregroundColor
     * @param string $foregroundColor Card foreground color.
     * @return $this
     */
    public function setForegroundColor($foregroundColor)
    {
        $this->container['foregroundColor'] = $foregroundColor;

        return $this;
    }

    /**
     * Gets combinedAsset
     * @return \CyberSource\Model\TmsCardArtCombinedAsset
     */
    public function getCombinedAsset()
    {
        return $this->container['combinedAsset'];
    }

    /**
     * Sets combinedAsset
     * @param \CyberSource\Model\TmsCardArtCombinedAsset $combinedAsset
     * @return $this
     */
    public function setCombinedAsset($combinedAsset)
    {
        $this->container['combinedAsset'] = $combinedAsset;

        return $this;
    }

    /**
     * Gets brandLogoAsset
     * @return \CyberSource\Model\TmsCardArtBrandLogoAsset
     */
    public function getBrandLogoAsset()
    {
        return $this->container['brandLogoAsset'];
    }

    /**
     * Sets brandLogoAsset
     * @param \CyberSource\Model\TmsCardArtBrandLogoAsset $brandLogoAsset
     * @return $this
     */
    public function setBrandLogoAsset($brandLogoAsset)
    {
        $this->container['brandLogoAsset'] = $brandLogoAsset;

        return $this;
    }

    /**
     * Gets issuerLogoAsset
     * @return \CyberSource\Model\TmsCardArtIssuerLogoAsset
     */
    public function getIssuerLogoAsset()
    {
        return $this->container['issuerLogoAsset'];
    }

    /**
     * Sets issuerLogoAsset
     * @param \CyberSource\Model\TmsCardArtIssuerLogoAsset $issuerLogoAsset
     * @return $this
     */
    public function setIssuerLogoAsset($issuerLogoAsset)
    {
        $this->container['issuerLogoAsset'] = $issuerLogoAsset;

        return $this;
    }

    /**
     * Gets iconAsset
     * @return \CyberSource\Model\TmsCardArtIconAsset
     */
    public function getIconAsset()
    {
        return $this->container['iconAsset'];
    }

    /**
     * Sets iconAsset
     * @param \CyberSource\Model\TmsCardArtIconAsset $iconAsset
     * @return $this
     */
    public function setIconAsset($iconAsset)
    {
        $this->container['iconAsset'] = $iconAsset;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


