<?php
/**
 * TmsNetworkTokenServicesVisaTokenService
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * TmsNetworkTokenServicesVisaTokenService Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class TmsNetworkTokenServicesVisaTokenService implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'tmsNetworkTokenServices_visaTokenService';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'enableService' => 'bool',
        'enableTransactionalTokens' => 'bool',
        'tokenRequestorId' => 'string',
        'relationshipId' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'enableService' => null,
        'enableTransactionalTokens' => null,
        'tokenRequestorId' => null,
        'relationshipId' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'enableService' => 'enableService',
        'enableTransactionalTokens' => 'enableTransactionalTokens',
        'tokenRequestorId' => 'tokenRequestorId',
        'relationshipId' => 'relationshipId'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'enableService' => 'setEnableService',
        'enableTransactionalTokens' => 'setEnableTransactionalTokens',
        'tokenRequestorId' => 'setTokenRequestorId',
        'relationshipId' => 'setRelationshipId'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'enableService' => 'getEnableService',
        'enableTransactionalTokens' => 'getEnableTransactionalTokens',
        'tokenRequestorId' => 'getTokenRequestorId',
        'relationshipId' => 'getRelationshipId'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['enableService'] = isset($data['enableService']) ? $data['enableService'] : null;
        $this->container['enableTransactionalTokens'] = isset($data['enableTransactionalTokens']) ? $data['enableTransactionalTokens'] : null;
        $this->container['tokenRequestorId'] = isset($data['tokenRequestorId']) ? $data['tokenRequestorId'] : null;
        $this->container['relationshipId'] = isset($data['relationshipId']) ? $data['relationshipId'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets enableService
     * @return bool
     */
    public function getEnableService()
    {
        return $this->container['enableService'];
    }

    /**
     * Sets enableService
     * @param bool $enableService Indicates if the service for network tokens for the Visa card association are enabled
     * @return $this
     */
    public function setEnableService($enableService)
    {
        $this->container['enableService'] = $enableService;

        return $this;
    }

    /**
     * Gets enableTransactionalTokens
     * @return bool
     */
    public function getEnableTransactionalTokens()
    {
        return $this->container['enableTransactionalTokens'];
    }

    /**
     * Sets enableTransactionalTokens
     * @param bool $enableTransactionalTokens Indicates if network tokens for the Visa card association are enabled for transactions
     * @return $this
     */
    public function setEnableTransactionalTokens($enableTransactionalTokens)
    {
        $this->container['enableTransactionalTokens'] = $enableTransactionalTokens;

        return $this;
    }

    /**
     * Gets tokenRequestorId
     * @return string
     */
    public function getTokenRequestorId()
    {
        return $this->container['tokenRequestorId'];
    }

    /**
     * Sets tokenRequestorId
     * @param string $tokenRequestorId Token Requestor ID provided by Visa during the registration process for the Tokenization Service  Pattern: ^[0-9]{11}\\\\z$\" Min Length: 11 Max Length: 11 Example:  \"40000000082\"
     * @return $this
     */
    public function setTokenRequestorId($tokenRequestorId)
    {
        $this->container['tokenRequestorId'] = $tokenRequestorId;

        return $this;
    }

    /**
     * Gets relationshipId
     * @return string
     */
    public function getRelationshipId()
    {
        return $this->container['relationshipId'];
    }

    /**
     * Sets relationshipId
     * @param string $relationshipId Relationship ID provided by visa  Min Length: 1 Max Length: 100 Example: \"24681921-40000000082\"
     * @return $this
     */
    public function setRelationshipId($relationshipId)
    {
        $this->container['relationshipId'] = $relationshipId;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


