<?php
/**
 * Tmsv2TokenizedCard
 *
 * PHP version 5
 *
 * @category Class
 * @package  CyberSource
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * CyberSource Merged Spec
 *
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace CyberSource\Model;

use \ArrayAccess;

/**
 * Tmsv2TokenizedCard Class Doc Comment
 *
 * @category    Class
 * @package     CyberSource
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Tmsv2TokenizedCard implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'tmsv2TokenizedCard';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'links' => '\CyberSource\Model\Tmsv2TokenizedCardLinks',
        'id' => 'string',
        'object' => 'string',
        'accountReferenceId' => 'string',
        'consumerId' => 'string',
        'createInstrumentIdentifier' => 'bool',
        'source' => 'string',
        'state' => 'string',
        'reason' => 'string',
        'number' => 'string',
        'expirationMonth' => 'string',
        'expirationYear' => 'string',
        'type' => 'string',
        'cryptogram' => 'string',
        'securityCode' => 'string',
        'eci' => 'string',
        'requestorId' => 'string',
        'enrollmentId' => 'string',
        'tokenReferenceId' => 'string',
        'paymentAccountReference' => 'string',
        'card' => '\CyberSource\Model\Tmsv2TokenizedCardCard',
        'passcode' => '\CyberSource\Model\Tmsv2TokenizedCardPasscode',
        'metadata' => '\CyberSource\Model\Tmsv2TokenizedCardMetadata'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerFormats = [
        'links' => null,
        'id' => null,
        'object' => null,
        'accountReferenceId' => null,
        'consumerId' => null,
        'createInstrumentIdentifier' => null,
        'source' => null,
        'state' => null,
        'reason' => null,
        'number' => null,
        'expirationMonth' => null,
        'expirationYear' => null,
        'type' => null,
        'cryptogram' => null,
        'securityCode' => null,
        'eci' => null,
        'requestorId' => null,
        'enrollmentId' => null,
        'tokenReferenceId' => null,
        'paymentAccountReference' => null,
        'card' => null,
        'passcode' => null,
        'metadata' => null
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'links' => '_links',
        'id' => 'id',
        'object' => 'object',
        'accountReferenceId' => 'accountReferenceId',
        'consumerId' => 'consumerId',
        'createInstrumentIdentifier' => 'createInstrumentIdentifier',
        'source' => 'source',
        'state' => 'state',
        'reason' => 'reason',
        'number' => 'number',
        'expirationMonth' => 'expirationMonth',
        'expirationYear' => 'expirationYear',
        'type' => 'type',
        'cryptogram' => 'cryptogram',
        'securityCode' => 'securityCode',
        'eci' => 'eci',
        'requestorId' => 'requestorId',
        'enrollmentId' => 'enrollmentId',
        'tokenReferenceId' => 'tokenReferenceId',
        'paymentAccountReference' => 'paymentAccountReference',
        'card' => 'card',
        'passcode' => 'passcode',
        'metadata' => 'metadata'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'links' => 'setLinks',
        'id' => 'setId',
        'object' => 'setObject',
        'accountReferenceId' => 'setAccountReferenceId',
        'consumerId' => 'setConsumerId',
        'createInstrumentIdentifier' => 'setCreateInstrumentIdentifier',
        'source' => 'setSource',
        'state' => 'setState',
        'reason' => 'setReason',
        'number' => 'setNumber',
        'expirationMonth' => 'setExpirationMonth',
        'expirationYear' => 'setExpirationYear',
        'type' => 'setType',
        'cryptogram' => 'setCryptogram',
        'securityCode' => 'setSecurityCode',
        'eci' => 'setEci',
        'requestorId' => 'setRequestorId',
        'enrollmentId' => 'setEnrollmentId',
        'tokenReferenceId' => 'setTokenReferenceId',
        'paymentAccountReference' => 'setPaymentAccountReference',
        'card' => 'setCard',
        'passcode' => 'setPasscode',
        'metadata' => 'setMetadata'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'links' => 'getLinks',
        'id' => 'getId',
        'object' => 'getObject',
        'accountReferenceId' => 'getAccountReferenceId',
        'consumerId' => 'getConsumerId',
        'createInstrumentIdentifier' => 'getCreateInstrumentIdentifier',
        'source' => 'getSource',
        'state' => 'getState',
        'reason' => 'getReason',
        'number' => 'getNumber',
        'expirationMonth' => 'getExpirationMonth',
        'expirationYear' => 'getExpirationYear',
        'type' => 'getType',
        'cryptogram' => 'getCryptogram',
        'securityCode' => 'getSecurityCode',
        'eci' => 'getEci',
        'requestorId' => 'getRequestorId',
        'enrollmentId' => 'getEnrollmentId',
        'tokenReferenceId' => 'getTokenReferenceId',
        'paymentAccountReference' => 'getPaymentAccountReference',
        'card' => 'getCard',
        'passcode' => 'getPasscode',
        'metadata' => 'getMetadata'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['links'] = isset($data['links']) ? $data['links'] : null;
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['object'] = isset($data['object']) ? $data['object'] : null;
        $this->container['accountReferenceId'] = isset($data['accountReferenceId']) ? $data['accountReferenceId'] : null;
        $this->container['consumerId'] = isset($data['consumerId']) ? $data['consumerId'] : null;
        $this->container['createInstrumentIdentifier'] = isset($data['createInstrumentIdentifier']) ? $data['createInstrumentIdentifier'] : null;
        $this->container['source'] = isset($data['source']) ? $data['source'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['reason'] = isset($data['reason']) ? $data['reason'] : null;
        $this->container['number'] = isset($data['number']) ? $data['number'] : null;
        $this->container['expirationMonth'] = isset($data['expirationMonth']) ? $data['expirationMonth'] : null;
        $this->container['expirationYear'] = isset($data['expirationYear']) ? $data['expirationYear'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['cryptogram'] = isset($data['cryptogram']) ? $data['cryptogram'] : null;
        $this->container['securityCode'] = isset($data['securityCode']) ? $data['securityCode'] : null;
        $this->container['eci'] = isset($data['eci']) ? $data['eci'] : null;
        $this->container['requestorId'] = isset($data['requestorId']) ? $data['requestorId'] : null;
        $this->container['enrollmentId'] = isset($data['enrollmentId']) ? $data['enrollmentId'] : null;
        $this->container['tokenReferenceId'] = isset($data['tokenReferenceId']) ? $data['tokenReferenceId'] : null;
        $this->container['paymentAccountReference'] = isset($data['paymentAccountReference']) ? $data['paymentAccountReference'] : null;
        $this->container['card'] = isset($data['card']) ? $data['card'] : null;
        $this->container['passcode'] = isset($data['passcode']) ? $data['passcode'] : null;
        $this->container['metadata'] = isset($data['metadata']) ? $data['metadata'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {

        return true;
    }


    /**
     * Gets links
     * @return \CyberSource\Model\Tmsv2TokenizedCardLinks
     */
    public function getLinks()
    {
        return $this->container['links'];
    }

    /**
     * Sets links
     * @param \CyberSource\Model\Tmsv2TokenizedCardLinks $links
     * @return $this
     */
    public function setLinks($links)
    {
        $this->container['links'] = $links;

        return $this;
    }

    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The Id of the Tokenized Card.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets object
     * @return string
     */
    public function getObject()
    {
        return $this->container['object'];
    }

    /**
     * Sets object
     * @param string $object The type. Possible Values: - tokenizedCard
     * @return $this
     */
    public function setObject($object)
    {
        $this->container['object'] = $object;

        return $this;
    }

    /**
     * Gets accountReferenceId
     * @return string
     */
    public function getAccountReferenceId()
    {
        return $this->container['accountReferenceId'];
    }

    /**
     * Sets accountReferenceId
     * @param string $accountReferenceId An identifier provided by the issuer for the account.
     * @return $this
     */
    public function setAccountReferenceId($accountReferenceId)
    {
        $this->container['accountReferenceId'] = $accountReferenceId;

        return $this;
    }

    /**
     * Gets consumerId
     * @return string
     */
    public function getConsumerId()
    {
        return $this->container['consumerId'];
    }

    /**
     * Sets consumerId
     * @param string $consumerId Identifier of the consumer within the wallet. Maximum 24 characters for VTS.
     * @return $this
     */
    public function setConsumerId($consumerId)
    {
        $this->container['consumerId'] = $consumerId;

        return $this;
    }

    /**
     * Gets createInstrumentIdentifier
     * @return bool
     */
    public function getCreateInstrumentIdentifier()
    {
        return $this->container['createInstrumentIdentifier'];
    }

    /**
     * Sets createInstrumentIdentifier
     * @param bool $createInstrumentIdentifier Specifies whether the InstrumentId should be created (true) or not (false). Possible Values: - `true`: The InstrumentId should be created. - `false`: The InstrumentId should be created.
     * @return $this
     */
    public function setCreateInstrumentIdentifier($createInstrumentIdentifier)
    {
        $this->container['createInstrumentIdentifier'] = $createInstrumentIdentifier;

        return $this;
    }

    /**
     * Gets source
     * @return string
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     * @param string $source Source of the payment instrument. Possible Values: - ONFILE - TOKEN - ISSUER
     * @return $this
     */
    public function setSource($source)
    {
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state State of the network token or network token provision. Possible Values:   ACTIVE : Network token is active.   SUSPENDED : Network token is suspended. This state can change back to ACTIVE.   DELETED : This is a final state for a network token instance.   UNPROVISIONED : A previous network token.
     * @return $this
     */
    public function setState($state)
    {
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets reason
     * @return string
     */
    public function getReason()
    {
        return $this->container['reason'];
    }

    /**
     * Sets reason
     * @param string $reason Issuers state for the network token Possible Values: - INVALID_REQUEST : The network token provision request contained invalid data. - CARD_VERIFICATION_FAILED : The network token provision request contained data that could not be verified. - CARD_NOT_ELIGIBLE : Card can currently not be used with issuer for tokenization. - CARD_NOT_ALLOWED : Card can currently not be used with card association for tokenization. - DECLINED : Card can currently not be used with issuer for tokenization. - SERVICE_UNAVAILABLE : The network token service was unavailable or timed out. - SYSTEM_ERROR : An unexpected error occurred with network token service, check configuration.
     * @return $this
     */
    public function setReason($reason)
    {
        $this->container['reason'] = $reason;

        return $this;
    }

    /**
     * Gets number
     * @return string
     */
    public function getNumber()
    {
        return $this->container['number'];
    }

    /**
     * Sets number
     * @param string $number The token requestor's network token for the provided PAN and consumer Id, if available.
     * @return $this
     */
    public function setNumber($number)
    {
        $this->container['number'] = $number;

        return $this;
    }

    /**
     * Gets expirationMonth
     * @return string
     */
    public function getExpirationMonth()
    {
        return $this->container['expirationMonth'];
    }

    /**
     * Sets expirationMonth
     * @param string $expirationMonth Two-digit month in which the network token expires. Format: `MM`. Possible Values: `01` through `12`.
     * @return $this
     */
    public function setExpirationMonth($expirationMonth)
    {
        $this->container['expirationMonth'] = $expirationMonth;

        return $this;
    }

    /**
     * Gets expirationYear
     * @return string
     */
    public function getExpirationYear()
    {
        return $this->container['expirationYear'];
    }

    /**
     * Sets expirationYear
     * @param string $expirationYear Four-digit year in which the network token expires. Format: `YYYY`.
     * @return $this
     */
    public function setExpirationYear($expirationYear)
    {
        $this->container['expirationYear'] = $expirationYear;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type The type of card (Card Network). Possible Values: - visa - mastercard - americanexpress
     * @return $this
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets cryptogram
     * @return string
     */
    public function getCryptogram()
    {
        return $this->container['cryptogram'];
    }

    /**
     * Sets cryptogram
     * @param string $cryptogram Value generated by the card association to be used alongside the network token for processing a payment.
     * @return $this
     */
    public function setCryptogram($cryptogram)
    {
        $this->container['cryptogram'] = $cryptogram;

        return $this;
    }

    /**
     * Gets securityCode
     * @return string
     */
    public function getSecurityCode()
    {
        return $this->container['securityCode'];
    }

    /**
     * Sets securityCode
     * @param string $securityCode 4-digit number generated by the card association to be used alogside the network token for processing a payment. Only supported for Amex and SCOF.
     * @return $this
     */
    public function setSecurityCode($securityCode)
    {
        $this->container['securityCode'] = $securityCode;

        return $this;
    }

    /**
     * Gets eci
     * @return string
     */
    public function getEci()
    {
        return $this->container['eci'];
    }

    /**
     * Sets eci
     * @param string $eci Raw Electronic Commerce Indicator provided by the card association with the result of the cardholder authentication.
     * @return $this
     */
    public function setEci($eci)
    {
        $this->container['eci'] = $eci;

        return $this;
    }

    /**
     * Gets requestorId
     * @return string
     */
    public function getRequestorId()
    {
        return $this->container['requestorId'];
    }

    /**
     * Sets requestorId
     * @param string $requestorId 11-digit identifier that uniquely identifies the Token Requestor.
     * @return $this
     */
    public function setRequestorId($requestorId)
    {
        $this->container['requestorId'] = $requestorId;

        return $this;
    }

    /**
     * Gets enrollmentId
     * @return string
     */
    public function getEnrollmentId()
    {
        return $this->container['enrollmentId'];
    }

    /**
     * Sets enrollmentId
     * @param string $enrollmentId Unique id to identify this PAN/ enrollment.
     * @return $this
     */
    public function setEnrollmentId($enrollmentId)
    {
        $this->container['enrollmentId'] = $enrollmentId;

        return $this;
    }

    /**
     * Gets tokenReferenceId
     * @return string
     */
    public function getTokenReferenceId()
    {
        return $this->container['tokenReferenceId'];
    }

    /**
     * Sets tokenReferenceId
     * @param string $tokenReferenceId Unique ID for netwrok token.
     * @return $this
     */
    public function setTokenReferenceId($tokenReferenceId)
    {
        $this->container['tokenReferenceId'] = $tokenReferenceId;

        return $this;
    }

    /**
     * Gets paymentAccountReference
     * @return string
     */
    public function getPaymentAccountReference()
    {
        return $this->container['paymentAccountReference'];
    }

    /**
     * Sets paymentAccountReference
     * @param string $paymentAccountReference Payment account reference.
     * @return $this
     */
    public function setPaymentAccountReference($paymentAccountReference)
    {
        $this->container['paymentAccountReference'] = $paymentAccountReference;

        return $this;
    }

    /**
     * Gets card
     * @return \CyberSource\Model\Tmsv2TokenizedCardCard
     */
    public function getCard()
    {
        return $this->container['card'];
    }

    /**
     * Sets card
     * @param \CyberSource\Model\Tmsv2TokenizedCardCard $card
     * @return $this
     */
    public function setCard($card)
    {
        $this->container['card'] = $card;

        return $this;
    }

    /**
     * Gets passcode
     * @return \CyberSource\Model\Tmsv2TokenizedCardPasscode
     */
    public function getPasscode()
    {
        return $this->container['passcode'];
    }

    /**
     * Sets passcode
     * @param \CyberSource\Model\Tmsv2TokenizedCardPasscode $passcode
     * @return $this
     */
    public function setPasscode($passcode)
    {
        $this->container['passcode'] = $passcode;

        return $this;
    }

    /**
     * Gets metadata
     * @return \CyberSource\Model\Tmsv2TokenizedCardMetadata
     */
    public function getMetadata()
    {
        return $this->container['metadata'];
    }

    /**
     * Sets metadata
     * @param \CyberSource\Model\Tmsv2TokenizedCardMetadata $metadata
     * @return $this
     */
    public function setMetadata($metadata)
    {
        $this->container['metadata'] = $metadata;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\CyberSource\ObjectSerializer::sanitizeForSerialization($this));
    }
}


