<?php
$site_url = get_site_url();
//echo '$site_url = ' . $site_url . '<br/>';
global $cart_count, $page_url, $page_title;
?>

<!DOCTYPE html>
<html lang="fr">

<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/x-icon"
        href="<?php echo get_site_url() . '/wp-content/uploads/2022/07/favicon_16x16.png'; ?>">

    <?php wp_head(); ?>

    <title>
        <?php
        echo $page_title;
        ?>
    </title>

    <script src="https://kit.fontawesome.com/107d488b99.js" crossorigin="anonymous"></script>


</head>

<body>

    <input type="hidden" id="username" value="<?php echo isset($_SESSION['username']) ? $_SESSION['username'] : '' ;  ?>">
    <input type="hidden" id="order_id" value="<?php echo isset($_SESSION['order_id']) ? $_SESSION['order_id'] : '' ;  ?>">

    <header>
        <nav class="">
            <div class="row1">
                <a href="<?php echo get_site_url(); ?>/" class="logo">
                    <img src="<?php echo get_template_directory_uri(); ?>/images/logo-sm-2.png" alt="logo">
                </a>

                <div class="search-wrapper">
                    <input type="text" placeholder="What are you looking for?">
                    <i class="fa-solid fa-magnifying-glass search-icon"></i>
                </div>

                <a href="tel:8185556788">
                    <div class="call-service">
                        <i class="fa-solid fa-phone-volume call-icon"></i>
                        <div>
                            <h2>Call Center</h2>
                            <h3>818-555 67 88</h3>
                        </div>
                    </div>
                </a>


                <div class="mobile-icons">

                    <div class="account-icons">
                        <div class="basket-wrapper" onclick="toggleBasket();">
                            <i class="fa-solid fa-basket-shopping basket-icon"></i>
                            <div class="basket-count">
                                <span id="basket_cart_count"><?php echo $cart_count; ?></span>
                            </div>
                        </div>
                        <div class="icons-separator"></div>
                        <a href="<?php echo get_site_url(); ?>/wishlist/"><i
                                class="fa-regular fa-heart heart-icon"></i></a>
                        <a href="<?php echo get_site_url(); ?>/account/"
                            title="<?php echo isset($_SESSION['username']) ? $_SESSION['username'] : "Not logged id"; ?>">
                            <i class="fa-regular fa-user user-icon"></i>
                        </a>
                    </div>

                    <i class="fa-solid fa-bars menu-icon"></i>
                </div>
            </div>

            <div class="basket-panel">


            </div>

            <div class="menu-container">
                <div class="menu-wrapper">
                    <i class="fa-solid fa-xmark close-icon"></i>

                    <div class="menu-scroll">
                        <div class="menu-row1">
                            <div class="menu-link">
                                <i class="fa-solid fa-basket-shopping"></i>
                                <a href="#">New Products</a>
                                <div class="menu-link-selector"></div>
                            </div>

                            <div id="best-sales" class="menu-link">
                                <a href="#">Best Sales</a>
                                <div class="link-plus-wrapper">
                                    <div class="link-plus">HOT</div>
                                </div>
                                <div class="menu-link-selector"></div>
                            </div>

                            <div id="special-offers" class="menu-link" onmouseover="/*specialOffersHovered(event);*/"
                                onclick="specialOffersHovered(event);">
                                <i class="fa-solid fa-percent percentage-icon"></i>
                                <a href="#">Special Offers</a>
                                <i class="fa-solid fa-caret-down angle-down"></i>
                                <i class="fa-solid fa-caret-up angle-up"></i>
                                <div class="menu-link-selector"></div>
                            </div>
                            <div id="mobile-sub-menu1-container"></div>

                            <div id="quick-find" class="menu-link" onmouseover="/*quickFindHovered(event);*/"
                                onclick="quickFindHovered(event);">
                                <a href="#">Quick Find</a>
                                <i class="fa-solid fa-caret-down angle-down"></i>
                                <i class="fa-solid fa-caret-up angle-up"></i>
                                <div class="menu-link-selector"></div>
                            </div>
                            <div id="mobile-sub-menu2-container"></div>

                            <div class="menu-link">
                                <a href="">News</a>
                                <div class="menu-link-selector"></div>
                            </div>

                            <div class="menu-link">
                                <a href="">Contact</a>
                                <div class="menu-link-selector"></div>
                            </div>

                            <div id="buy-xtra-theme" class="menu-link">
                                <a href="">Buy XTRA Theme</a>
                                <div class="menu-link-selector"></div>
                            </div>

                            <div class="social-icons">
                                <i class="fa-brands fa-facebook-f social-icon"></i>
                                <i class="fa-brands fa-twitter social-icon"></i>
                                <i class="fa-brands fa-instagram social-icon"></i>
                            </div>

                            <div class="copyright">
                                <h2>© Copyright 2025</h2>
                            </div>

                            <button>
                                <i class="fa-solid fa-gift present-icon"></i>
                                Daily Offers
                            </button>
                        </div>

                        <div class="menu-row2">
                            <div id="desktop-sub-menu-1-container">
                                <div class="sub-menu-1" onmouseleave="">
                                    <div class="product-class">
                                        <img src="<?php echo get_template_directory_uri(); ?>/images/menu-1/fish.png" alt="fish">
                                        <h1>Fishes and Raw Meats</h1>
                                        <h2>20% OFF</h2>
                                    </div>
                                    <div class="product-class">
                                        <img src="<?php echo get_template_directory_uri(); ?>/images/menu-1/vegetables.png"
                                            alt="vegetables">
                                        <h1>Fruits and Vegetables</h1>
                                        <h2>15% OFF</h2>
                                    </div>
                                    <div class="product-class">
                                        <img src="<?php echo get_template_directory_uri(); ?>/images/menu-1/bread.png" alt="bread">
                                        <h1>Breads and Sweats</h1>
                                        <h2>50% OFF</h2>
                                    </div>
                                    <div class="product-class">
                                        <img src="<?php echo get_template_directory_uri(); ?>/images/menu-1/milk.png" alt="milk">
                                        <h1>Milks and Proteins</h1>
                                        <h2>40% OFF</h2>
                                    </div>
                                    <div class="product-class">
                                        <img src="<?php echo get_template_directory_uri(); ?>/images/menu-1/meat.png" alt="meat">
                                        <h1>Ready touse Foods</h1>
                                        <h2>45% OFF</h2>
                                    </div>
                                </div>
                            </div>

                            <div id="desktop-sub-menu-2-container">
                                <div class="sub-menu-2" onmouseleave="">
                                    <div class="categories">
                                        <h1 onclick="toggleCategories();">Categories
                                            <i class="fa-solid fa-caret-down mobile-angle-down"></i>
                                        </h1>
                                        <div id="categories-menu">
                                            <div>
                                                <i class="fa-solid fa-folder category-icon"></i>
                                                <a href="#">Supermarket</a>
                                            </div>
                                            <div>
                                                <i class="fa-solid fa-folder category-icon"></i>
                                                <a href="#">Fishes and Meats</a>
                                            </div>
                                            <div>
                                                <i class="fa-solid fa-folder category-icon"></i>
                                                <a href="#">Vegetables</a>
                                            </div>
                                            <div>
                                                <i class="fa-solid fa-folder category-icon"></i>
                                                <a href="#">Milks and Proteins</a>
                                            </div>
                                            <div>
                                                <i class="fa-solid fa-folder category-icon"></i>
                                                <a href="#">Cleaning Tools</a>
                                            </div>
                                            <div>
                                                <i class="fa-solid fa-folder category-icon"></i>
                                                <a href="#">Bestsellers</a>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="sub-menu-separator"></div>
                                    <div class="top-tags">
                                        <h1 onclick="toggleTopTags();">Top Tags
                                            <i class="fa-solid fa-caret-down mobile-angle-down"></i>
                                        </h1>
                                        <div id="top-tags-menu">
                                            <div>
                                                <i class="fa-solid fa-tag tag-icon"></i>
                                                <a href="#">Pasta</a>
                                            </div>
                                            <div>
                                                <i class="fa-solid fa-tag tag-icon"></i>
                                                <a href="#">Sauce</a>
                                            </div>
                                            <div>
                                                <i class="fa-solid fa-tag tag-icon"></i>
                                                <a href="#">Cowboy</a>
                                            </div>
                                            <div>
                                                <i class="fa-solid fa-tag tag-icon"></i>
                                                <a href="#">Steak</a>
                                            </div>
                                            <div>
                                                <i class="fa-solid fa-tag tag-icon"></i>
                                                <a href="#">Burgers</a>
                                            </div>
                                            <div>
                                                <i class="fa-solid fa-tag tag-icon"></i>
                                                <a href="#">Spray</a>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="quick-access">
                                        <h1 onclick="toggleQuickAccess();">Quick Access
                                            <i class="fa-solid fa-caret-down mobile-angle-down"></i>
                                        </h1>
                                        <div id="quick-access-menu">
                                            <div>
                                                <i class="fa-solid fa-link link-icon"></i>
                                                <a href="#">About</a>
                                            </div>
                                            <div>
                                                <i class="fa-solid fa-link link-icon"></i>
                                                <a href="#">FAQ</a>
                                            </div>
                                            <div>
                                                <i class="fa-solid fa-link link-icon"></i>
                                                <a href="#">My Account</a>
                                            </div>
                                            <div>
                                                <i class="fa-solid fa-link link-icon"></i>
                                                <a href="#">Orders</a>
                                            </div>
                                            <div>
                                                <i class="fa-solid fa-link link-icon"></i>
                                                <a href="#">Downloads</a>
                                            </div>
                                            <div>
                                                <i class="fa-solid fa-link link-icon"></i>
                                                <a href="#">Lost Password</a>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>

                        </div>

                    </div>


                </div>



            </div>

        </nav>

        <?php
        if ($page_url == get_site_url()) {
            ?>
            <div class="hero">
                <h2><span>XtraSupermarket</span></h2>
                <h1>Fresher than Ever</h1>
                <p>A supermarket is a self-service shop offering a wide variety of food, beverages and household products,
                    organized into sections.</p>
                <button class="button-1">25% Off Festival</button>
                <button class="button-2">Discover Shop</button>
            </div>


            <img class="woman-shopping-image" src="<?php echo get_template_directory_uri(); ?>/images/woman-shopping.png"
                alt="woman-shopping-image">

            <div class="sales-services">
                <div class="service">
                    <img src="<?php echo get_template_directory_uri(); ?>/images/sales-services/free-shipping.png" alt="free-shipping">
                    <div>
                        <h1>Free shipping</h1>
                        <p>On all orders over $50.00</p>
                    </div>
                </div>
                <div class="service">
                    <img src="<?php echo get_template_directory_uri(); ?>/images/sales-services/free-return.png" alt="free-return">
                    <div>
                        <h1>Return for free</h1>
                        <p>On all orders over $50.00</p>
                    </div>
                </div>
                <div class="service">
                    <img src="<?php echo get_template_directory_uri(); ?>/images/sales-services/secure-payment.png" alt="secure-payment">
                    <div>
                        <h1>Secure Payment</h1>
                        <p>On all orders over $50.00</p>
                    </div>
                </div>
                <div class="service">
                    <img src="<?php echo get_template_directory_uri(); ?>/images/sales-services/support.png" alt="support">
                    <div>
                        <h1>24/7 Support</h1>
                        <p>On all orders over $50.00</p>
                    </div>
                </div>
            </div>
            <?php
        }
        ?>
    </header>