<?php
session_start();

global $page_url;
$page_title = get_the_title();

$cart_count = 0;
if(isset($_SESSION['user_id']) && isset($_SESSION['order_id'])) {
    $cart_count = getCartProductsCount($_SESSION['user_id'], $_SESSION['order_id']);
}

function load_index_files_function() {
    global $page_url;

    wp_enqueue_style('index-style', get_template_directory_uri() . '/css/index.css');
    wp_enqueue_style('basket-style', get_template_directory_uri() . '/css/basket-cart.css');

    if ( endsWith($page_url, '/account/') ) {                  
        wp_enqueue_style('account-style', get_template_directory_uri() . '/css/account.css');
    } else 
    if ( endsWith($page_url, '/wishlist/') ) {                  
        wp_enqueue_style('wishlist-style', get_template_directory_uri() . '/css/wishlist.css');
    } else 
    if ( endsWith($page_url, '/cart/') || 
           endsWith($page_url, '/checkout/') || 
           endsWith($page_url, '/order/') || 
           endsWith($page_url, '/order-cancel/') || 
           endsWith($page_url, '/order-success/')) {                  
        wp_enqueue_style('cart-style', get_template_directory_uri() . '/css/cart.css');
    }

    if ( endsWith($page_url, '/order/') ) {                  
        wp_enqueue_script('stripe-script', 'https://js.stripe.com/v3/');
    } 

    wp_enqueue_script('fontawesome-javascript', get_template_directory_uri() . '/js/fontawesome.js');
}
add_action('wp_enqueue_scripts', 'load_index_files_function');

$user = wp_get_current_user();
//echo '<pre>' . print_r($user, true) . '</pre>';
//echo 'username:' . $_SESSION['username'] . '<br>';

$page_url = get_permalink();
//echo '$page-url = ' . $page_url . '</br>';
//echo '$site-url = ' . get_site_url() . '</br>';

if ( endsWith($page_url, '/basket/') ) { 
                                
    include ABSPATH . 'wp-content/themes/my-theme/pages/basket.php';
    exit;
} else 
if ( endsWith($page_url, '/account-orders/') ) { 
                                
    include ABSPATH . 'wp-content/themes/my-theme/pages/account-orders.php';
    exit;
} else 
if ( endsWith($page_url, '/account-details/') ) { 
                                
    include ABSPATH . 'wp-content/themes/my-theme/pages/account-details.php';
    exit;
}

get_header();

if ( endsWith($page_url, '/account/') ) { 
                                
    include ABSPATH . 'wp-content/themes/my-theme/pages/account.php';
} else 

if ( endsWith($page_url, '/wishlist/') ) { 
                                
    include ABSPATH . 'wp-content/themes/my-theme/pages/wishlist.php';
} else 

if ( endsWith($page_url, '/cart/') ) { 
                                
    include ABSPATH . 'wp-content/themes/my-theme/pages/cart.php';
} else 

if ( endsWith($page_url, '/checkout/') ) { 
                                
    include ABSPATH . 'wp-content/themes/my-theme/pages/checkout.php';
} else 

if ( endsWith($page_url, '/order/') ) { 
                                
    include ABSPATH . 'wp-content/themes/my-theme/pages/order.php';
} else 

if ( endsWith($page_url, '/order-success/') ) { 
                                
    include ABSPATH . 'wp-content/themes/my-theme/pages/order-success.php';
} else 

if ( endsWith($page_url, '/order-cancel/') ) { 
                                
    include ABSPATH . 'wp-content/themes/my-theme/pages/order-cancel.php';
}

get_footer();