<div class="cart-section">
    <div class="cart-head">
        <h1>Checkout</h1>
        <div class="breadcrumbs">
            <i class="fa-solid fa-house"></i>
            <i class="fa-solid fa-angle-right"></i>
            Checkout
        </div>
    </div>

    <?php
    if (isset($_SESSION['username'])) {
        ?>

        <div class="cart-body">

            <div class="payment-process">
                <a href="<?php echo get_site_url() . '/cart/'; ?>" class="payment-process-step">
                    <div class="process-step-number">1</div>
                    <h1>Shopping cart</h1>
                </a>
                <div class="payment-process-separator"><i class="fa-solid fa-arrow-right"></i></div>
                <a href="<?php echo get_site_url() . '/checkout/'; ?>'; ?>"
                    class="payment-process-step payment-process-step-selected">
                    <div class="process-step-number">2</div>
                    <h1>Checkout details</h1>
                </a>
                <div class="payment-process-separator"><i class="fa-solid fa-arrow-right"></i></div>
                <a href="<?php echo get_site_url() . '/order/'; ?>" class="payment-process-step">
                    <div class="process-step-number">3</div>
                    <h1>Order complete</h1>
                </a>
            </div>

            <?php
            echo do_shortcode('[woocommerce_checkout] ');
            if(false) {
            ?>

            <div class="order-container">
                <div class="billing-details">
                    <div class="billing-details-title">Billing details</div>
                    <?php
                    $sql = "SELECT * FROM wp_users 
                            WHERE user_login = '" . $_SESSION['username'] . "' 
                            ;";

                    //echo '$sql: ' . $sql . '<br>';
                    try {
                        $results = $wpdb->get_results($sql);
                        //echo '<pre>' . print_r($results, true) . '</pre>';

                        if ($results && count($results) > 0) {
                            $result = $results[0];

                            $first_name = get_user_meta($result->ID, 'first_name', true);
                            $last_name = get_user_meta($result->ID, 'last_name', true);

                            ?>
                            <div class="user-infos">
                                <div>
                                    <label for="first_name">Firstname <span>*</span></label><br>
                                    <input type="text" name="first_name" value="<?php echo $first_name; ?>">
                                </div>
                                <div>
                                    <label for="last_name">Lastname <span>*</span></label><br>
                                    <input type="text" name="last_name" value="<?php echo $last_name ?>">
                                </div>
                            </div>
                            <div class="user-infos">
                                <div>
                                    <label for="country_region">Country/Region <span>*</span></label><br>
                                    <input type="text" name="country_region" value="">
                                </div>
                                <div>
                                    <label for="street_address">Street address <span>*</span></label><br>
                                    <input type="text" name="street_address" value="">
                                </div>
                            </div>
                            <div class="user-infos">
                                <div>
                                    <label for="town_city">Town/City <span>*</span></label><br>
                                    <input type="text" name="town_city" value="">
                                </div>
                                <div>
                                    <label for="state">State <span>*</span></label><br>
                                    <input type="text" name="state" value="">
                                </div>
                            </div>
                            <div class="user-infos">
                                <div>
                                    <label for="zip_code">Zip code <span>*</span></label><br>
                                    <input type="text" name="zip_code" value="">
                                </div>
                                <div>
                                    <label for="phone">Phone <span>*</span></label><br>
                                    <input type="text" name="phone" value="">
                                </div>
                            </div>
                            <div class="user-infos">
                                <div>
                                    <label for="email_address">Email address <span>*</span></label><br>
                                    <input type="text" name="email_address" value="">
                                </div>
                            </div>
                            <?php
                        }

                    } catch (Exception $ex) {
                        echo 'Exception: ' . $ex->getMessage() . '<br>';
                    }

                    ?>


                </div>
                <div class="order-details">
                    <div class="order-details-title">Your order</div>

                    <table class="order-details-table">
                        <tr>
                            <th>Product</th>
                            <th>Subtotal</th>
                        </tr>
                        <?php
                        if (isset($_SESSION['order_id'])) {
                            $sql = "SELECT * FROM wp_extra_cart_products cp 
                                JOIN wp_extra_products p ON cp.productId = p.Id 
                                JOIN wp_users u ON cp.userId = u.ID 
                                JOIN wp_extra_orders o ON cp.orderId = o.orderId AND o.userId = u.ID 
                                WHERE u.ID = " . $_SESSION['user_id'] . " 
                                AND o.orderId = " . $_SESSION['order_id'] . " 
                                ;";
                            //echo '$sql: ' . $sql . '<br>';

                            $total = 0;
                            $cartProducts = [];
                            try {
                                $results = $wpdb->get_results($sql);
                                echo "Error: " . $wpdb->last_error . '<br>';

                                if ($results && count($results) > 0) {
                                    foreach ($results as $result) {
                                        $subtoal = $result->NewPrice * $result->quantity;
                                        $total += $subtoal;
                                        $cartProducts[] = [
                                            'name' => $result->Name,
                                            'quantity' => $result->quantity
                                        ];
                                        ?>
                                        <tr class="product-row">
                                            <td><?php echo $result->Name . ' x ' . $result->quantity ?></td>
                                            <td><?php echo '$' . $subtoal; ?></td>
                                        </tr>
                                        <?php
                                    }
                                    $_SESSION['cart_products'] = $cartProducts;
                                }

                            } catch (Exception $ex) {
                                echo 'Exception: ' . $ex->getMessage() . '<br>';
                            }
                        }

                        ?>

                        <tr>
                            <td><strong>Total</strong></td>
                            <td>$<?php echo $total ?? '0'; ?></td>
                        </tr>

                    </table>

                    <a class="place-order-link" href="<?php echo $root_path . '/pages/order.php'; ?>">Place order</a>

                </div>
            </div>
            <?php
            }
            ?>

        </div>
        <?php
    }
    ?>


</div>