<div class="cart-section">
    <div class="cart-head">
        <h1>Order</h1>
        <div class="breadcrumbs">
            <i class="fa-solid fa-house"></i>
            <i class="fa-solid fa-angle-right"></i>
            Order
        </div>
    </div>

    <?php
    if (isset($_SESSION['username'])) {
        ?>

        <div class="cart-body">

            <div class="payment-process">
                <a href="<?php echo get_site_url() . '/cart/'; ?>" class="payment-process-step">
                    <div class="process-step-number">1</div>
                    <h1>Shopping cart</h1>
                </a>
                <div class="payment-process-separator"><i class="fa-solid fa-arrow-right"></i></div>
                <a href="<?php echo get_site_url() . '/checkout/'; ?>" class="payment-process-step">
                    <div class="process-step-number">2</div>
                    <h1>Checkout details</h1>
                </a>
                <div class="payment-process-separator"><i class="fa-solid fa-arrow-right"></i></div>
                <a href="<?php echo get_site_url() . '/order/'; ?>"
                    class="payment-process-step payment-process-step-selected">
                    <div class="process-step-number">3</div>
                    <h1>Order complete</h1>
                </a>
            </div>

            <div class="order">
                <div class="success-container">
                    <div class="success-icon"><i class="fa-solid fa-check"></i></div>
                    <h1>Payment Successful!</h1><br>
                    <p>Thank you for your purchase. Your payment has been processed successfully.</p>
                    <?php
                    if ($_GET['session_id']) {
                        $session = \Stripe\Checkout\Session::retrieve($_GET['session_id']);
                        $paymentIntent = \Stripe\PaymentIntent::retrieve($session->payment_intent);
                        if ($paymentIntent->status == 'succeeded') {
                            finalizeOrder($_SESSION['user_id'], $_SESSION['order_id']);
                            unset($_SESSION['order_id']);
                            ?>
                            <strong>Payment ID: </strong><?php echo $paymentIntent->id; ?><br>
                            <strong>Status: </strong><?php echo $paymentIntent->status; ?><br>
                            <strong>Amount: </strong>$<?php echo number_format($paymentIntent->amount / 100, 2); ?><br>
                            <?php
                        }
                    }
                    ?>
                    <a href="../cart/">Back to shopping cart</a>
                </div>
            </div>

        </div>
        <?php
    }
    ?>


</div>