<?php
require_once ABSPATH . 'wp-content/themes/my-theme/payment/config.php';
?>
<script type="text/javascript">
    const page = 'order.php';

    const stripe = Stripe('<?php echo $stripe_publishable_key; ?>');

    async function handlePayment(products) {
        console.log('products: ', products);

        const url = '../wp-json/api/v1/create-checkout-session/';

        try {
            const response = await fetch(url, {
                method: "POST",
                headers: {
                    'Content-type': 'application/json'
                },
                body: JSON.stringify({
                    products: products
                })
            })

            const session = await response.json();
            console.log('session: ', session);

            if (session.id) {
                const result = await stripe.redirectToCheckout({
                    'sessionId': session.id
                });

                if (result.error) {
                    console.log('Payment error: ', result.error.message);
                    alert('Payment error: ', result.error.message);
                }

            } else {
                console.log('Session error: ', session);
                alert('Could not create checkout session!');
            }
        } catch (error) {
            console.log('Payment error: ', error);
            alert('An error occured while processing your payment, Please try again!');
        }
    }
</script>

<div class="cart-section">
    <div class="cart-head">
        <h1>Cart</h1>
        <div class="breadcrumbs">
            <i class="fa-solid fa-house"></i>
            <i class="fa-solid fa-angle-right"></i>
            Cart
        </div>
    </div>

    <?php
    if (isset($_SESSION['username'])) {
        ?>

        <div class="cart-body">

            <div class="payment-process">
                <a href="<?php echo get_site_url() . '/cart/'; ?>" class="payment-process-step">
                    <div class="process-step-number">1</div>
                    <h1>Shopping cart</h1>
                </a>
                <div class="payment-process-separator"><i class="fa-solid fa-arrow-right"></i></div>
                <a href="<?php echo get_site_url() . '/checkout/'; ?>" class="payment-process-step">
                    <div class="process-step-number">2</div>
                    <h1>Checkout details</h1>
                </a>
                <div class="payment-process-separator"><i class="fa-solid fa-arrow-right"></i></div>
                <a href="<?php echo get_site_url() . '/order/'; ?>"
                    class="payment-process-step payment-process-step-selected">
                    <div class="process-step-number">3</div>
                    <h1>Order complete</h1>
                </a>
            </div>

            <?php
            echo do_shortcode('[woocommerce_order_tracking]');
            if(false) {
            ?>

            <div class="order">
                <?php
                //echo 'Cart Products:<br><pre>' . print_r($_SESSION['cart_products'], true) . '</pre>';
            
                $stripeProducts = getStripeProducts();
                echo 'Stripe Products:<br><pre>' . print_r($stripeProducts, true) . '</pre>';
            
                $orderProducts = [];
                foreach ($_SESSION['cart_products'] as $cartProduct) {
                    foreach ($stripeProducts as $stripeProduct) {
                        if ($cartProduct['name'] == $stripeProduct['name']) {
                            $orderProducts[] = [
                                'name' => $cartProduct['name'],
                                'priceId' => $stripeProduct['priceId'],
                                'quantity' => $cartProduct['quantity']
                            ];
                        }
                    }
                }
                //echo 'Order Products:<br><pre>' . print_r($orderProducts, true) . '</pre>';
                ?>
                <script type="text/javascript">
                    const products = <?php echo json_encode($orderProducts) ?>;
                    handlePayment(products);
                </script>
            </div>
            <?php
            }
            ?>

        </div>
        <?php
    }
    ?>

</div>